/**
 * Metro configuration for React Native
 * https://github.com/facebook/react-native
 *
 * @format
 */

const { getDefaultConfig, mergeConfig } = require('@react-native/metro-config');
const path = require('path');

const defaultConfig = getDefaultConfig(__dirname);

const config = {
  transformer: {
    getTransformOptions: async () => ({
      transform: {
        experimentalImportSupport: false,
        inlineRequires: true,
      },
    }),
  },
  resolver: {
    assetExts: [...defaultConfig.resolver.assetExts, 'png', 'jpg', 'jpeg', 'gif', 'webp', 'svg'],
    sourceExts: [...defaultConfig.resolver.sourceExts, 'js', 'jsx', 'ts', 'tsx', 'json'],
    resolveRequest: (context, realModuleName, platform, moduleName) => {
      // 🔧 Fix for missing-asset-registry-path in old react-navigation-stack
      if (realModuleName === 'missing-asset-registry-path') {
        return {
          type: 'sourceFile',
          filePath: path.resolve(
            __dirname,
            'node_modules/react-native/Libraries/Image/AssetRegistry.js'
          ),
        };
      }

      // 🔧 Fix for ViewPropTypes removed in React Native 0.74
      // Redirect imports to deprecated-react-native-prop-types
      if (
        moduleName === 'ViewPropTypes' ||
        (moduleName === 'react-native' && context.dependency?.name === 'ViewPropTypes')
      ) {
        return {
          type: 'sourceFile',
          filePath: path.resolve(
            __dirname,
            'node_modules/deprecated-react-native-prop-types/index.js'
          ),
        };
      }

      return context.resolveRequest(context, realModuleName, platform, moduleName);
    },
  },
};

module.exports = mergeConfig(defaultConfig, config);
