// // Polyfill for ErrorUtils - required for React Native on some Android versions
// // This must be loaded before any other modules that might use ErrorUtils

// (function() {
//   'use strict';

//   // Ensure global object exists
//   if (typeof global === 'undefined') {
//     if (typeof window !== 'undefined') {
//       window.global = window;
//     } else if (typeof self !== 'undefined') {
//       self.global = self;
//     } else {
//       // Last resort - create a minimal global
//       this.global = this;
//     }
//   }

//   // Polyfill for ViewPropTypes - removed in React Native 0.74
//   // Required for legacy libraries like react-native-message-bar
//   try {
//     const DeprecatedViewPropTypes = require('deprecated-react-native-prop-types');
//     const ReactNative = require('react-native');

//     // Add to global
//     if (!global.ViewPropTypes) {
//       global.ViewPropTypes = DeprecatedViewPropTypes.ViewPropTypes;
//     }

//     // Add to React Native module itself
//     if (!ReactNative.ViewPropTypes) {
//       ReactNative.ViewPropTypes = DeprecatedViewPropTypes.ViewPropTypes;
//     }
//   } catch (e) {
//     console.warn('Could not load deprecated-react-native-prop-types, using fallback:', e);
//     // Fallback polyfill if package is not available
//     const simplePropType = function() {
//       return simplePropType;
//     };
//     simplePropType.isRequired = simplePropType;

//     const viewPropTypes = {
//       style: simplePropType,
//     };

//     // Add to global
//     if (!global.ViewPropTypes) {
//       global.ViewPropTypes = viewPropTypes;
//     }

//     // Add to React Native module
//     try {
//       const ReactNative = require('react-native');
//       if (!ReactNative.ViewPropTypes) {
//         ReactNative.ViewPropTypes = viewPropTypes;
//       }
//     } catch (err) {
//       console.warn('Could not patch react-native:', err);
//     }
//   }

//   // Create a robust ErrorUtils implementation
//   const createErrorUtils = () => {
//     let _globalHandler = null;

//     return {
//       setGlobalHandler(callback) {
//         _globalHandler = callback;
//       },
//       getGlobalHandler() {
//         return _globalHandler;
//       },
//       reportError(error) {
//         if (_globalHandler) {
//           try {
//             _globalHandler(error, false);
//           } catch (handlerError) {
//             console.error('Error in error handler:', handlerError);
//             console.error('Original error:', error);
//           }
//         } else {
//           console.error('Error:', error);
//         }
//       },
//       reportFatalError(error) {
//         if (_globalHandler) {
//           try {
//             _globalHandler(error, true);
//           } catch (handlerError) {
//             console.error('Error in fatal error handler:', handlerError);
//             console.error('Original fatal error:', error);
//           }
//         } else {
//           console.error('Fatal error:', error);
//         }
//       }
//     };
//   };

//   // Always create/replace ErrorUtils to ensure it has all required methods
//   // This handles cases where ErrorUtils might be partially defined
//   try {
//     const errorUtils = createErrorUtils();

//     // Try to preserve existing global handler if one exists
//     if (global.ErrorUtils && typeof global.ErrorUtils.getGlobalHandler === 'function') {
//       const existingHandler = global.ErrorUtils.getGlobalHandler();
//       if (existingHandler) {
//         errorUtils.setGlobalHandler(existingHandler);
//       }
//     }

//     // Set ErrorUtils on global with configurable property so it can be updated if needed
//     if (Object.defineProperty) {
//       try {
//         Object.defineProperty(global, 'ErrorUtils', {
//           value: errorUtils,
//           writable: true,
//           enumerable: false,
//           configurable: true,
//         });
//       } catch (e) {
//         // Fallback if defineProperty fails
//         global.ErrorUtils = errorUtils;
//       }
//     } else {
//       global.ErrorUtils = errorUtils;
//     }
//   } catch (error) {
//     console.error('Failed to initialize ErrorUtils:', error);
//   }
// })();

// shim.js - PropTypes polyfill for React Native 0.74+
(function () {
  try {
    const ReactNative = require('react-native');
    const DeprecatedPropTypes = require('deprecated-react-native-prop-types');

    // 🧩 Fix for ViewPropTypes removed in React Native 0.71+
    if (!ReactNative.ViewPropTypes) {
      ReactNative.ViewPropTypes = DeprecatedPropTypes.ViewPropTypes;
    }

    // 🧩 Fix for ImagePropTypes removed in React Native 0.71+
    if (!ReactNative.ImagePropTypes) {
      ReactNative.ImagePropTypes = DeprecatedPropTypes.ImagePropTypes;
    }

    // 🧩 Fix for Image.propTypes
    if (ReactNative.Image && !ReactNative.Image.propTypes) {
      ReactNative.Image.propTypes = DeprecatedPropTypes.ImagePropTypes;
    }

    // 🧩 Fix for TextPropTypes
    if (!ReactNative.TextPropTypes) {
      ReactNative.TextPropTypes = DeprecatedPropTypes.TextPropTypes;
    }

    // 🧩 Fix for Text.propTypes.allowFontScaling - CRITICAL FIX
    if (ReactNative.Text) {
      if (!ReactNative.Text.propTypes) {
        ReactNative.Text.propTypes = DeprecatedPropTypes.TextPropTypes || {};
      }
      // Ensure specific properties exist
      if (!ReactNative.Text.propTypes.allowFontScaling) {
        ReactNative.Text.propTypes.allowFontScaling = function() { return null; };
      }
    }

    // 🧩 Fix for View.propTypes
    if (ReactNative.View && !ReactNative.View.propTypes) {
      ReactNative.View.propTypes = DeprecatedPropTypes.ViewPropTypes;
    }

    // 🧩 Fix for TextInput.propTypes
    if (ReactNative.TextInput && !ReactNative.TextInput.propTypes) {
      ReactNative.TextInput.propTypes = DeprecatedPropTypes.TextInputPropTypes || {};
    }

    // 🧩 Fix for ScrollView.propTypes
    if (ReactNative.ScrollView && !ReactNative.ScrollView.propTypes) {
      ReactNative.ScrollView.propTypes = DeprecatedPropTypes.ViewPropTypes || {};
    }

    // Optional: patch SafeAreaView if any old code expects it
    if (!ReactNative.SafeAreaView) {
      ReactNative.SafeAreaView = ReactNative.View;
    }

    console.log('✅ PropTypes shim loaded successfully');

  } catch (e) {
    console.warn('⚠️ Shim initialization failed:', e);
  }

  // 🛠 Global error handler (optional)
  if (typeof ErrorUtils !== 'undefined' && !global._shimErrorHandlerInstalled) {
    const defaultHandler = ErrorUtils.getGlobalHandler && ErrorUtils.getGlobalHandler();
    ErrorUtils.setGlobalHandler((error, isFatal) => {
      console.log('🔥 Global error caught by shim:', error);
      if (defaultHandler) {
        defaultHandler(error, isFatal);
      }
    });
    global._shimErrorHandlerInstalled = true;
  }
})();
