import React, { Component } from "react";
import { View, ActivityIndicator, Modal } from "react-native";
import { colors } from "../../assets";

const WithFetchingWrapper = WrappedComp => {
    class WithFetching extends Component {
        state = { isFetching: false };

        cbShowLoader = isFetching => this.setState({ isFetching });

        renderActivityIndicator() {
            return this.state.isFetching ? (
                <Modal animationType="slide" transparent visible>
                    <View style={styles.indicatorContainer}>
                        <ActivityIndicator
                            size="large"
                            color={colors.tertiary}
                        />
                    </View>
                </Modal>
            ) : null;
        }

        render() {
            return (
                <View style={styles.container}>
                    <WrappedComp
                        {...this.props}
                        cbShowLoader={this.cbShowLoader}
                    />
                    {this.renderActivityIndicator()}
                </View>
            );
        }
    }
    return WithFetching;
};

const styles = {
    container: { flex: 1 },
    indicatorContainer: {
        top: 0,
        bottom: 0,
        left: 0,
        right: 0,
        alignItems: "center",
        justifyContent: "center",
        position: "absolute",
        backgroundColor: "rgba(0,0,0,0.2)"
    }
};

export default WithFetchingWrapper;
