import React, {Component} from 'react';
// import { NetInfo } from "react-native";
import NetInfo from '@react-native-community/netinfo';
import {connect} from 'react-redux';

import {generalSaveAction} from '../../actions/GeneralActions';
import {NETWORK_INFO} from '../../actions/ActionTypes';

const WithFetchingWrapper = WrappedComp => {
  class WithFetching extends Component {
    handleNetConnectivityChange = isNetworkConnected =>
      this.pushNetInfoToRedux(isNetworkConnected);

    pushNetInfoToRedux = isNetworkConnected =>
      this.props.generalSaveAction(NETWORK_INFO, {
        isNetworkConnected,
      });

    componentWillMount() {
      //   NetInfo.isConnected.fetch().then(this.pushNetInfoToRedux);
      //   this.netInfoListenerRef = NetInfo.isConnected.addEventListener(
      //     'connectionChange',
      //     this.handleNetConnectivityChange,
      //   );
    }

    componentWillUnmount() {}

    render() {
      return <WrappedComp {...this.props} />;
    }
  }

  const actions = {generalSaveAction};

  const connectedComp = connect(null, actions)(WithFetching);

  return connectedComp;
};
export default WithFetchingWrapper;
