import _ from "lodash";
import moment from "moment";
import { Platform, StatusBar, Alert } from "react-native";
import { showMessage as flashShowMessage } from "react-native-flash-message";
import { API_KEY_GOOGLE } from "../constants";

let userLoggedIn;
let userToken;
let adminFee;
let iosStatusBarHeight;
let navigatorRef;
let userType;
let userID;
let RegisterScreen;
let lunchValue;
let helpline;


class Util {
    setUserToken = token => (userToken = token);
    getUserToken = () => userToken;

    setUserType = type => (userType = type);
    getUserType = () => userType;

    setUserID = userid => (userID = userid);
    getUserID = () => userID;

    setLunchValue = lunchvalue => (lunchValue = lunchvalue);
    getLunchValue = () => lunchValue;

    setHelpLine = helpLine => (helpline = helpLine);
    getHelpLine = () => helpline;

    setRegisterScreen = registerScreen => (RegisterScreen = registerScreen);
    getRegisterScreen = () => RegisterScreen;

    setUserLoggedIn = val => (userLoggedIn = val);
    getIsUserLoggedIn = () => userLoggedIn;

    setNavigatorRef = ref => (navigatorRef = ref);
    getNavigatorRef = () => navigatorRef;

    setAdminFee = amount => (adminFee = amount);
    getAdminFee = () => adminFee;

    getDeviceType = () => (Platform.OS === "android" ? "android" : "ios");

    keyExtractor = (item, index) => index;

    setIOSStatusBarHeight = height => (iosStatusBarHeight = height);

    isPlatformAndroid = () => Platform.OS === "android";

    validateEmail(email) {
        const re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }

    getStatusBarHeight() {
        return this.isPlatformAndroid()
            ? StatusBar.currentHeight
            : iosStatusBarHeight;
    }

    getError(err: Object) {
        errors = undefined;
        if (err && Object.keys(err).length) {
            errors = Object.keys(err).map(key => err[key]);
        }
        return errors;
    }

    showError(err) {
        console.log('=== UTILS: showError called with:', err);

        // Handle different error formats
        let errorTitle = "Error";
        let errorMessage = "Something went wrong. Please try again.";

        // If error is a structured error object (from WebService.js)
        if (err && typeof err === 'object') {
            if (err.title && err.message) {
                // Structured error like ERROR_REQUEST_TIMEOUT
                errorTitle = err.title;
                errorMessage = err.message;
            } else if (err.data) {
                // API response error with data object
                const errorData = this.getError(err.data);
                if (errorData) {
                    errorMessage = Array.isArray(errorData) ? errorData.join('\n') : errorData;
                }
            } else {
                // Try to extract error from object keys
                const errorData = this.getError(err);
                if (errorData) {
                    errorMessage = Array.isArray(errorData) ? errorData.join('\n') : errorData;
                }
            }
        } else if (typeof err === 'string') {
            // Simple string error
            errorMessage = err;
        }

        console.log('=== UTILS: Showing alert with title:', errorTitle, 'message:', errorMessage);

        // Show Alert box instead of flash message
        this.showAlert(errorTitle, errorMessage);
    }

    showMessage = (
        title: String = "",
        message: String,
        type: String = "error"
    ) => {
        // Map old alert types to new flash message types
        const flashType = type === "error" ? "danger" : type;

        flashShowMessage({
            message: title,
            description: message,
            type: flashType,
            duration: 4000,
        });
    };

    showAlert = (
        title = "Alert",
        msg = "you have an alert",
        onSuccess = undefined
    ) => {
        let actionArr = onSuccess
            ? [
                { text: "OK", onPress: () => onSuccess && onSuccess() },
                {
                    text: "Cancel",
                    onPress: () => console.log("Cancel Pressed"),
                    style: "cancel"
                }
            ]
            : [{ text: "OK", onPress: () => onSuccess && onSuccess() }];
        Alert.alert(title, msg, actionArr, { cancelable: false });
    };

    getAddress(latitude, longitude) {

        fetch(
            `https://maps.googleapis.com/maps/api/geocode/json?address=${latitude},${longitude}&key=${API_KEY_GOOGLE}`).
            then((response) => response.json())
            .then((responseJson) => {
                const results = JSON.stringify(responseJson);

                const address_current = responseJson.results[0].formatted_address;

                return responseJson.results[0].formatted_address;
            }
            );


    }

    distance(lat1, lon1, lat2, lon2) {
       
        if (lat1 == lat2 && lon1 == lon2) {
            return 0;
        } else {
            var radLat1 = (Math.PI * lat1) / 180;
            var radLat2 = (Math.PI * lat2) / 180;
            var theta = lon1 - lon2;
            var radTheta = (Math.PI * theta) / 180;
            var dist =
                Math.sin(radLat1) * Math.sin(radLat2) +
                Math.cos(radLat1) * Math.cos(radLat2) * Math.cos(radTheta);
            if (dist > 1) {
                dist = 1;
            }
            dist = Math.acos(dist);
            dist = (dist * 180) / Math.PI;
            dist = dist * 60 * 1.1515;

            // return (dist / 1.609344).toFixed(2); //km
            return (dist).toFixed(2);

        }
    }


    isMobilePhoneValid(val: string) {
        const re = /^[+]?(1\-|1\s|1|\d{3}\-|\d{3}\s|)?((\(\d{3}\))|\d{3})(\-|\s)?(\d{3})(\-|\s)?(\d{4})$/;
        return re.test(val);
    }
    isEmpty = (val) => {
        return _.isEmpty(val);
    }
    isNull = (val) => {
        return _.isNull(val);
    }

    calculateDiffTime = (shift_end_time, shift_start_time) => {

        let diffTime;
        let dif;
        if (shift_start_time > shift_end_time) {
            dif = moment(shift_end_time, "HH:mm:a").diff(
                moment(shift_start_time, "HH:mm:a")
            );
            diffTime = 24 - Math.abs(moment.duration(dif).hours());

        } else {
            // dif = moment(shift_end_time, "HH:mm:a").diff(
            //     moment(shift_start_time, "HH:mm:a")
            // );

            // diffTime = moment.duration(dif).hours();

            const duration = moment.duration(moment(shift_end_time, "HH:mm:a").diff(
                moment(shift_start_time, "HH:mm:a")
            ));

            const hours = parseInt(duration.asHours());
            const minutes = parseInt(duration.asMinutes()) % 60;

            var timeSpent = hours + ":" + minutes;

            diffTime = timeSpent
                .split(':')
                .reduce((r, a, i) =>
                    r + a * Math.pow(60, -i), 0);

        }

        return Math.abs(diffTime);
    };

    convertminutesTOhour = (minutes) => {

        let time = minutes
        let showhr;

        var hours = Math.floor(time / 60)
        var minutes = time % 60

        hours == 0 ? showhr = minutes + " min" :
         minutes == 0 ? showhr = hours +" hrs" : showhr = hours + ":" + minutes + " hrs";

        return showhr;
    }

    ShowDifftimeHour = (shift_end_time, shift_start_time) => {

        let diffTime;
        let dif, timeSpent;
        if (shift_start_time > shift_end_time) {
            dif = moment(shift_end_time, "HH:mm:a").diff(
                moment(shift_start_time, "HH:mm:a")
            );
            diffTime = 24 - Math.abs(moment.duration(dif).hours());


        } else {
            // dif = moment(shift_end_time, "HH:mm:a").diff(
            //     moment(shift_start_time, "HH:mm:a")
            // );

            // diffTime = moment.duration(dif).hours();

            const duration = moment.duration(moment(shift_end_time, "HH:mm:a").diff(
                moment(shift_start_time, "HH:mm:a")
            ));

            const hours = parseInt(duration.asHours());
            const minutes = parseInt(duration.asMinutes()) % 60;

            minutes == 0 ? timeSpent = hours : timeSpent = hours + ":" + minutes;

        }

        return timeSpent;
    };

    calculateDiffDate(b, a) {
        let diffDays = moment(b, "YYYY-MM-DD").diff(moment(a, "YYYY-MM-DD"), 'days');
        return ++diffDays;
    }
}

export default new Util();
