import { NotificationBar } from "../components";

// @flow

const REQUEST = "REQUEST";
const SUCCESS = "SUCCESS";
const FAILURE = "FAILURE";

function createRequestTypes(base) {
    const res = {};
    [REQUEST, SUCCESS, FAILURE].forEach(type => {
        res[type] = `${base}_${type}`;
    });
    return res;
}

export const GENERAL = "GENERAL";

export const LOGOUT = "LOGOUT";
export const NETWORK_INFO = "NETWORK_INFO";

export const USER = createRequestTypes("USER");

export const CATEGORIES = createRequestTypes("CATEGORIES");

export const DUMP = createRequestTypes("DUMP");
export const DOC_DATA = createRequestTypes("CONTRACTORS_DATA");

export const LIST_ACTIVE_CONTRACTS = createRequestTypes(
    "LIST_ACTIVE_CONTRACTS"
);
export const LIST_ALL_CONTRACTS = createRequestTypes("LIST_ALL_CONTRACTS");
export const LIST_ACTIVE_REQUESTS = createRequestTypes("LIST_ACTIVE_REQUESTS");
export const LIST_REJECT_REQUESTS = createRequestTypes("LIST_REJECT_REQUESTS");
export const POST_SHIFT_CONTRACT = createRequestTypes("POST_SHIFT_CONTRACT");

export const LIST_CLOSE_CONTRACTS = createRequestTypes("LIST_CLOSE_CONTRACTS");
export const LIST_CLOSE_REQUESTS = createRequestTypes("LIST_CLOSE_REQUESTS");
export const CONTRACTORS = createRequestTypes("CONTRACTORS");
export const LIST_NOTIFICATIONS = createRequestTypes("LIST_NOTIFICATIONS");
export const INFO_CONTENT = createRequestTypes("INFO_CONTENT");
export const TERMS_CONDITIONS = createRequestTypes("TERMS_CONDITIONS");

// --------------------- NotificationBar
export const SHOW_BAR = "SHOW_BAR";
export const HIDE_BAR = "HIDE_BAR";


export const ADMIN_FEE_AMOUNT = "ADMIN_FEE_AMOUNT";