import { GENERAL } from "./ActionTypes";

export function generalAction(
  url: String,
  payload: Object,
  successType: String,
  failureType: String,
  successCb: Function = undefined,
  failureCb: Function = undefined,
  isGetRequest: Boolean = false,
  isConcat: Boolean = false
) {


  const action = {
    type: GENERAL,
    url,
    payload,
    successType,
    failureType,
    successCb,
    failureCb,
    isGetRequest,
    isConcat
  };

 

  return action;
}

export function generalSaveAction(
  type: string,
  data: object,
  isConcat: Boolean = false
) {
  return {
    type,
    data,
    isConcat
  };
}

export function generalDispatchType(type: string) {
  return {
    type
  };
}

export function notificationBar(type: string, data: object = {}) {
  return {
    type,
    data
  };
}
