import React, { Component } from "react";
import {
    View,
    StyleSheet,
    Text,
    Image,
    Platform,
    TextInput,
    TouchableWithoutFeedback,
    TouchableOpacity
} from "react-native";
import { Metrics } from "../../services";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";
import {
    Separator,
    ButtonView,
    ProfileImage,
    TextLabel
} from "../../components";
import { getCurrentRouteName } from "../../services/NavigationService";
import StarRating from "react-native-star-rating";
import HTML from "react-native-render-html";

const BasicModal = (deleteContract, hideModal, children, increaseHeight) => {
    return (
        <TouchableWithoutFeedback>
            <View
                style={[
                    styles.inputWrapper,
                    styles.OSModelStyle,
                    increaseHeight ? { marginBottom: 20 } : {},
                    {
                        height: Metrics.halfScreenHeight / 1.5
                    }
                ]}
            >
                {children}
                <View style={{ flex: 1, flexDirection: "row" }}>
                    <TouchableOpacity
                        onPress={deleteContract}
                        style={[
                            styles.modalFooter,
                            { borderBottomLeftRadius: 6, borderRightWidth: 1 }
                        ]}
                    >
                        <Text style={styles.textColor2}>Yes</Text>
                    </TouchableOpacity>
                    <TouchableOpacity
                        onPress={hideModal}
                        style={[
                            styles.modalFooter,
                            { borderBottomRightRadius: 6 }
                        ]}
                    >
                        <Text style={styles.textColor2}>No</Text>
                    </TouchableOpacity>
                </View>
            </View>
        </TouchableWithoutFeedback>
    );
};

const DeleteModal = ({ deleteContract, hideModal, text1, text2 }) => {
    return BasicModal(
        deleteContract,
        hideModal,
        <View style={[styles.modalFirstColumn, { paddingVertical: 25 }]}>
            <Text style={styles.textColor}>{text1}</Text>
            <Text style={styles.textColor}>{text2}</Text>
        </View>
    );
};

const AcceptModal = ({
    deleteContract,
    hideModal,
    text1,
    text2,
    total,
    showTotal = true
}) => {
    return BasicModal(
        deleteContract,
        hideModal,
        <View
            style={[
                styles.modalFirstColumn,
                { paddingTop: 25, paddingBottom: 10 }
            ]}
        >
            <Text style={styles.textColor}>{text1}</Text>
            <Text style={styles.textColor}>{text2}</Text>
            {showTotal && (
                <ButtonView style={styles.ButtonViewStyle}>
                    <Text style={styles.bidText}>Total</Text>
                    <Text style={styles.rateText}>${total}</Text>
                </ButtonView>
            )}
        </View>
    );
};

const RejectModal = ({
    deleteContract,
    hideModal,
    onChangeText,
    value,
    onFocus,
    onBlur,
    boo
}) => {
    return BasicModal(
        deleteContract,
        hideModal,
        <View
            style={[
                styles.modalFirstColumn,
                { paddingVertical: 10, marginVertical: 30 }
            ]}
        >
            <Text style={styles.textColor}>
                Please enter the reason to reject the
            </Text>
            <Text style={styles.textColor}>request</Text>
            <TextInput
                numberOfLines={5}
                multiline={true}
                onChangeText={onChangeText}
                value={value}
                style={styles.inputMessageStyle}
                onFocus={onFocus}
                onBlur={onBlur}
            />
        </View>,
        boo
    );
};

const innerInfoModal = (text1, text2) => {
    return (
        <View style={styles.infoMain}>
            <View style={styles.infoView1}>
                <Text style={styles.infoText1}>{text1}</Text>
            </View>
            <View style={styles.infoView2}>
                <Text style={styles.infoText2}>{text2}</Text>
            </View>
        </View>
    );
};

const InfoModal = ({ costMile, maxRadius, contract_status }) => {
    let Total = +costMile * +maxRadius;
    return (
        <TouchableWithoutFeedback>
            <View style={[styles.inputWrapper, styles.OSInfoStyle]}>
                {innerInfoModal("Cost per Mile", `$${costMile}`)}
                {innerInfoModal(
                    getCurrentRouteName() === "myScheduleDetail" ||
                        getCurrentRouteName() === "onboardProjectsDetail" ||
                        (getCurrentRouteName() == "detailScreen" &&
                            contract_status == "close")
                        ? "Radius"
                        : "Maximum Radius",
                    `${maxRadius}miles`
                )}
                <Separator style={[styles.separatorStyle, { height: 20 }]} />
                {innerInfoModal("Total Cost ", `$${Total.toFixed(2)}`)}
            </View>
        </TouchableWithoutFeedback>
    );
};

const AllInfo = ({ note }) => {
    const source = {
        html: note
      };

    return (
        <TouchableWithoutFeedback>
            <View
                style={[
                    styles.inputWrapper,
                    { paddingHorizontal: 20, paddingVertical: 20 }
                ]}
            >
                <HTML source={source} />
            </View>
        </TouchableWithoutFeedback>
    );
};

const InfoMileage = ({ rate, diffTime, contract_type }) => {
    return (
        <TouchableWithoutFeedback>
            <View style={[styles.inputWrapper, styles.OSInfoStyle]}>
                <Text style={[styles.textRating, { marginTop: 10 }]}>
                    Per Hour : {rate}
                </Text>
                <Text style={[styles.textRating, { marginTop: 10 }]}>
                    {`${contract_type} Hours : ${diffTime} hrs`}
                </Text>
                <Text style={[styles.textRating, { marginTop: 10 }]}>
                    Total : {diffTime * rate}
                </Text>
            </View>
        </TouchableWithoutFeedback>
    );
};

const Rating = ({ img, name, rating, selectedStar, onPress }) => {
    return (
        <TouchableWithoutFeedback>
            <View style={[styles.inputWrapper, { paddingVertical: 25 }]}>
                <ProfileImage
                    radius={100}
                    img={img}
                    style={{ borderWidth: 2, borderColor: "white" }}
                />
                <Text style={[styles.textRating, { marginTop: 10 }]}>
                    Rate your experience with
                </Text>
                <Text style={[styles.textRating, { marginBottom: 20 }]}>
                    {name}
                </Text>
                <StarRating
                    disabled={false}
                    maxStars={5}
                    rating={rating}
                    starSize={40}
                    fullStarColor={"rgb(255,186,73)"}
                    selectedStar={selectedStar}
                />
                <TouchableOpacity
                    onPress={onPress}
                    style={{
                        width: "100%",
                        marginTop: 30,
                        justifyContent: "center",
                        alignItems: "center",
                        borderTopColor: "#f8f8f8",
                        borderTopWidth: 1
                    }}
                >
                    <View style={{ alignItems: "center", marginTop: 25 }}>
                        <Text style={styles.infoText1}>OK</Text>
                    </View>
                </TouchableOpacity>
            </View>
        </TouchableWithoutFeedback>
    );
};

function heading(label, {}, enable) {
    return (
        <TextLabel
            type="medium"
            size="medium"
            color={"black"}
            style={enable ? styles.boldText : styles.disableText}
        >
            {label}
        </TextLabel>
    );
}

function labelButton(txt1, txt2, style) {
    return (
        <View style={[styles.eachView, style]}>
            <Text style={styles.firstText}>{txt1}</Text>
            <Text style={styles.txtContract}>{txt2}</Text>
        </View>
    );
}

function bidRateLabelButton(
    txt,
    labels = false,
    callBack,
    enable,
    type,
    perHour,
    hourTotal
) {
    return (
        <View style={[styles.defaultStyle, { marginVertical: 5 }]}>
            <TouchableOpacity onPress={callBack}>
                <Image
                    style={{ margin: 10 }}
                    resizeMode="contain"
                    source={enable ? icons.ic_enable : icons.ic_disable}
                />
            </TouchableOpacity>
            <View style={{ flex: 2.5 }}>
                {heading(
                    txt,
                    [styles.mileageBidLabelStyle, { marginBottom: -5 }],
                    enable
                )}
            </View>
            {labels && (
                <View
                    style={[
                        styles.ViewLabelButton,
                        {
                            flex: 2,
                            justifyContent:
                                type === "Contract"
                                    ? "flex-end"
                                    : "space-between",
                            flexDirection: "row"
                        }
                    ]}
                >
                    {type === "Shift" &&
                        labelButton("Per Hour", `$${perHour}`, {
                            width: "49%"
                        })}
                    {type === "Shift" &&
                        labelButton("Hour Total", `$${hourTotal}`, {
                            width: "49%"
                        })}
                    {type === "Contract" &&
                        labelButton("Total", `$${hourTotal}`, {
                            width: "75%"
                        })}
                    {/*labelButton("Total ( Mileage + Bid )", `$${100}`, {
          width: "49%"
        })*/}
                </View>
            )}
        </View>
    );
}

function inputText(onChangeText, bidRate, editable, isError = false) {
    return (
        <View
            style={{
                flexDirection: "row",
                alignItems: "center",
                width: "96%",
                borderBottomColor: "#959dad",
                borderBottomWidth: 1,
                paddingBottom: 0
            }}
        >
            <TextInput
                style={[
                    styles.textInputStyle,
                    isError ? { borderColor: "#f44336" } : {}
                ]}
                onChangeText={onChangeText}
                placeholder="Bid Amount"
                keyboardType="numeric"
                value={bidRate}
                editable={editable}
                autoCapitalize="none"
            />
            <Image
                resizeMode="contain"
                source={icons.ic_dollar}
                style={{}}
                width={Metrics.images.small}
                height={Metrics.images.small}
            />
        </View>
    );
}

const Options = ({
    type,
    perHour,
    hourTotal,
    onClickSec,
    onClickFirst,
    enableFir,
    enableSec,
    onPress,
    onChangeText,
    bidRate
}) => {
    return (
        <TouchableWithoutFeedback>
            <View style={[styles.inputWrapper, { paddingVertical: 20 }]}>
                {bidRateLabelButton(
                    type == "Contract"
                        ? "Use the previous contract rate"
                        : "Use the previous hour rate",
                    true,
                    onClickFirst,
                    enableFir,
                    type,
                    perHour,
                    hourTotal
                )}
                {bidRateLabelButton(
                    type == "Contract"
                        ? "Enter the new contract rate you are willing to work for"
                        : "Enter the new hourly rate you are willing to work for",
                    false,
                    onClickSec,
                    enableSec,
                    type
                )}
                {inputText(onChangeText, bidRate, enableSec)}
                <TouchableOpacity
                    onPress={onPress}
                    style={{
                        width: "100%",
                        marginTop: 10,
                        justifyContent: "center",
                        alignItems: "center",
                        borderTopColor: "#f8f8f8",
                        borderTopWidth: 1
                    }}
                >
                    <View style={{ alignItems: "center", marginTop: 25 }}>
                        <Text style={styles.infoText1}>OK</Text>
                    </View>
                </TouchableOpacity>
            </View>
        </TouchableWithoutFeedback>
    );
};

export {
    DeleteModal,
    InfoModal,
    AcceptModal,
    RejectModal,
    Rating,
    Options,
    InfoMileage,
    AllInfo
};

const styles = StyleSheet.create({
    inputWrapper: {
        flexDirection: "column",
        width: Metrics.screenWidth - Metrics.xDoubleBaseMargin,
        alignItems: "center",
        marginTop: 10,
        height: "auto",
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        }
    },
    modalFirstColumn: {
        flex: 2,
        flexDirection: "column",
        justifyContent: "center",
        alignItems: "center"
    },
    textColor: {
        ...UIFont.font(fonts.regular, fontSize.medium, "#343434")
    },
    modalFooter: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        borderTopWidth: 1,
        borderColor: "#DDDDDD"
    },
    textColor2: {
        ...UIFont.font(fonts.regular, fontSize.medium, colors.CardDate)
    },
    separatorStyle: {
        backgroundColor: "#dde3f6",
        marginHorizontal: 20,
        marginVertical: 10
    },
    infoMain: {
        marginTop: 20,
        flexDirection: "row",
        paddingHorizontal: 20,
        flex: 2
    },
    infoView1: {
        alignItems: "flex-start",
        flex: 3
    },
    infoView2: {
        alignItems: "center",
        flex: 2
    },
    infoText1: {
        ...UIFont.font(fonts.regular, fontSize.xxLarge, colors.BlackColor)
    },
    infoText2: {
        ...UIFont.font(fonts.semiBold, fontSize.xxLarge, colors.BlackColor)
    },
    ButtonViewStyle: {
        marginTop: 15,
        height: 40,
        borderRadius: 5,
        borderWidth: 1,
        justifyContent: "center",
        alignItems: "center",
        borderColor: "#dde3f6",
        width: "60%",
        marginBottom: 35,
        paddingHorizontal: 50,
        paddingVertical: 10
    },
    bidText: {
        ...UIFont.font(fonts.regular, 9, "#2d3057")
    },
    rateText: {
        ...UIFont.font(fonts.regular, 16, "#212346")
    },
    inputMessageStyle: {
        marginVertical: 10,
        borderWidth: 1,
        borderColor: "#dde3f6",
        borderRadius: 3,
        height: Platform.OS && 70,
        textAlignVertical: "top",
        width:
            Metrics.screenWidth -
            Metrics.xDoubleBaseMargin -
            Metrics.xDoubleBaseMargin
    },
    textRating: {
        ...UIFont.font(fonts.regular, 17, "#112026")
    },
    OSInfoStyle: {
        ...Platform.select({
            ios: {
                height: "30%"
            },
            android: {
                height: "35%"
            }
        }),
        paddingVertical: 25
    },
    OSInfoStyle2: {
        ...Platform.select({
            ios: {
                height: "60%"
            },
            android: {
                height: "80%"
            }
        }),
        paddingVertical: 25
    },
    OSModelStyle: {
        ...Platform.select({
            ios: {
                height: "25%"
            },
            android: {
                height: "35%"
            }
        })
    },
    increaseHeight: {
        ...Platform.select({
            ios: {
                height: "25%"
            },
            android: {
                height: "45%"
            }
        })
    },
    defaultStyle: {
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        paddingRight: 10
    },
    mileageBidLabelStyle: {
        ...UIFont.font(fonts.semiBold, 16, colors.BlackColor),
        marginHorizontal: 20,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    eachView: {
        borderRadius: 5,
        borderStyle: "solid",
        borderWidth: 1,
        borderColor: "#dde3f6",
        alignItems: "center",
        justifyContent: "center",
        height: 40
    },
    firstText: {
        ...UIFont.font(fonts.regular, 9, colors.CardDate),
        lineHeight: 11,
        letterSpacing: 0
    },
    txtContract: {
        ...UIFont.font(fonts.semiBold, 16, colors.CardDate)
    },
    ViewLabelButton: {
        justifyContent: "center",
        alignItems: "center"
    },
    boldText: {
        ...UIFont.font(fonts.semiBold, 15, colors.ActiveTabTitle),
        marginTop: 10,
        marginBottom: 10,
        marginRight: 20,
        alignSelf: "flex-start",
        lineHeight: 22,
        letterSpacing: 0
    },
    disableText: {
        ...UIFont.font(fonts.semiBold, 15, colors.InActiveTabTitle),
        marginTop: 10,
        marginBottom: 10,
        marginRight: 20,
        alignSelf: "flex-start",
        lineHeight: 22,
        letterSpacing: 0
    },
    textInputStyle: {
        ...UIFont.font(fonts.reqular, fontSize.small, "#241332"),
        paddingRight: Metrics.baseMargin,
        letterSpacing: 0,
        padding: Platform.OS && 15,
        flex: 1
    }
});
