import _ from "lodash";
import React from "react";
import PropTypes from "prop-types";
import { View, Image } from "react-native";

import { Text, ButtonView, ValidationText } from "../../components";
import styles from "./styles";

import Colors from "../../services/Colors";
import Metrics from "../../services/Metrics";
import { Images, icons, colors } from "../../assets";
import { IMAGE_BASE_URL } from "../../services/WebService";

export default class ProfileImage extends React.PureComponent {
    static propTypes = {
        style: PropTypes.oneOfType([
            PropTypes.array,
            PropTypes.object,
            PropTypes.number
        ]),
        icon: PropTypes.object,
        image: PropTypes.object,
        onPress: PropTypes.func,
        imageSize: PropTypes.number,
        emailColor: PropTypes.string,
        textStyle: PropTypes.object,
        nameColor: PropTypes.string,
        btnViewStyle: PropTypes.object
    };

    static defaultProps = {
        style: {},
        textStyle: { textAlign: "center" },
        image: Images.bgContractor,
        btnViewStyle: {
            justifyContent: "center",
            alignItems: "center"
        }
    };

    renderStatus() {
        const { textStyle, data } = this.props;
        let userType =
                data.user_type == "Contractor" ? "Contractor" : "Facility",
            label = "",
            color = "";
        if (userType == "Contractor") {
            if (data.is_personnel_file_status == 2) {
                label = "Verified";
                color = "yellow";
            }
            if (data.is_personnel_file_status == 1) {
                label = "Pending";
                color = "green";
            }
            if (data.is_personnel_file_status == 0) {
                label = "Not Verified";
                color = "red";
            }
        }
        if (userType == "Facility") {
            if (data.is_profile_verified == 2) {
                label = "Verified";
                color = "yellow";
            }
            if (data.is_profile_verified == 1) {
                label = "Pending";
                color = "green";
            }
            if (data.is_profile_verified == 0) {
                label = "Not Verified";
                color = "red";
            }
        }

        return (
            <Text style={textStyle} name={label} nameColor={color}>
                {label}
            </Text>
        );
    }

    render() {
        const {
            style,
            emailColor,
            plus,
            onPress,
            imageValidation,
            imageSize,
            textStyle,
            nameColor,
            btnViewStyle,
            nameType,
            nameSize,
            emailType,
            emailSize,
            data,
            ...rest
        } = this.props;
        let img =
            data.image_url == ""
                ? "/uploads/user/no-image.png"
                : data.image_url;
        return (
            <ButtonView onPress={onPress} style={btnViewStyle}>
                <View elevation={15}>
                    <Image
                        source={{
                            uri: IMAGE_BASE_URL + "/" + img
                        }}
                        resizeMode="cover"
                        style={[
                            {
                                marginVertical: Metrics.smallMargin,
                                width: 100,
                                height: 100,
                                borderRadius: 50,
                                borderColor: colors.WhiteColor,
                                borderWidth: 2,
                                shadowColor: colors.BlackColor,
                                shadowOpacity: 0.8,
                                shadowRadius: 20,
                                shadowOffset: {
                                    height: 5,
                                    width: 5
                                },
                                padding: 5
                            },
                            imageSize
                        ]}
                    />
                    {!_.isUndefined(plus) ? (
                        <Image
                            source={Images.bgContractor}
                            resizeMode="contain"
                            style={{
                                position: "absolute",
                                bottom: 15,
                                right: 0
                            }}
                        />
                    ) : null}
                </View>
                {imageValidation ? null : (
                    <ValidationText text="something something" />
                )}
                {!_.isUndefined(data.full_name) ? (
                    <Text
                        style={textStyle}
                        nameType={nameType}
                        nameSize={nameSize}
                        name={data.full_name}
                        nameColor={nameColor ? nameColor : "white"}
                    >
                        {data.full_name}
                    </Text>
                ) : null}

                {!_.isUndefined(data.email) ? (
                    <Text
                        style={textStyle}
                        emailType={emailType}
                        emailSize={emailSize}
                        email={data.email}
                        emailColor={emailColor ? emailColor : "white"}
                    >
                        {data.email}
                    </Text>
                ) : null}
                {this.renderStatus()}
                
            </ButtonView>
        );
    }
}
