import React from "react";
import { View, Text, StyleSheet } from "react-native";
import { ButtonView } from "../";
import { colors, UIFont, fonts, fontSize } from "../../assets";

const SimilarButton = (btnStyle, txtStyle, label, onPress) => {
    return (
        <ButtonView
            style={[styles.ButtonViewStyle, btnStyle]}
            onPress={onPress}
        >
            <Text style={txtStyle}>{label}</Text>
        </ButtonView>
    );
};

const AcceptReject = (ViewWidth, width, text1, text2, cbOne, cbTwo) => {
    return (
        <View style={[styles.acceptRejectStyle, ViewWidth]}>
            {SimilarButton(
                { borderColor: "#08548c", width },
                styles.acceptText,
                text1,
                cbOne
            )}
            {SimilarButton(
                { borderColor: "#d93636", width },
                styles.rejectText,
                text2,
                cbTwo
            )}
        </View>
    );
};

const AcceptRejectBid = ({
    screen,
    bid_amount,
    text1,
    text2,
    cbOne,
    cbTwo
}) => {
    if (screen == "sent") {
        return AcceptReject(
            { width: "100%", paddingHorizontal: 20 },
            "49%",
            text1,
            text2,
            cbOne,
            cbTwo
        );
    } else {
        return (
            <View style={[styles.acceptRejectStyle, { paddingHorizontal: 20 }]}>
                <ButtonView
                    style={[
                        styles.ButtonViewStyle,
                        { borderColor: "#dde3f6", width: "32%" }
                    ]}
                >
                    <Text style={styles.bidText}>Bid Amount</Text>
                    <Text style={styles.rateText}>${bid_amount}</Text>
                </ButtonView>
                {AcceptReject(
                    { width: "66%" },
                    "49%",
                    text1,
                    text2,
                    cbOne,
                    cbTwo
                )}
            </View>
        );
    }
};

export default AcceptRejectBid;

const styles = StyleSheet.create({
    acceptRejectStyle: {
        height: 80,
        flexDirection: "row",
        justifyContent: "space-between"
    },
    ButtonViewStyle: {
        marginTop: 15,
        height: 40,
        borderRadius: 5,
        borderWidth: 1,
        justifyContent: "center",
        alignItems: "center"
    },
    acceptText: {
        ...UIFont.font(fonts.regular, 12, "#08548c")
    },
    rejectText: {
        ...UIFont.font(fonts.regular, 12, "#d93636")
    },
    bidText: {
        ...UIFont.font(fonts.regular, 9, "#2d3057")
    },
    rateText: {
        ...UIFont.font(fonts.regular, 16, "#212346")
    }
});
