import _ from "lodash";
import React from "react";
import PropTypes from "prop-types";
import { View, Image } from "react-native";
import { TextLabel, ButtonView } from "../";
import styles from "./styles";

const AppButton = (props: Object) => {
    const { style, textStyle, buttonTitle, onPress, enable,icon, btnColor, ...rest } = props;
    return (
        <ButtonView style={[styles.container, style]} onPress={onPress} enable ={enable} >
            {icon && <Image source={icon} style={{ marginRight: 15 }} />}
            <TextLabel
                type="medium"
                size="medium"
                emailColor={btnColor}
                style={[{
                    textAlign: "center",
                    fontStyle: "normal",
                    letterSpacing: 0,
                    color: '#fff',
                    fontSize: 16,
                    fontWeight: 'bold'
                }, textStyle]}
            >
                {buttonTitle}
            </TextLabel>
        </ButtonView>
    );
};

AppButton.propTypes = {
    style: PropTypes.oneOfType([
        PropTypes.array,
        PropTypes.object,
        PropTypes.number
    ]),
    enable : PropTypes.bool,
    onPress: PropTypes.func,
    icon: PropTypes.object,
    btnColor: PropTypes.string
};

AppButton.defaultProps = {
    style: {},
    title: "Title",
    icon: false,
    btnColor: "primary"
};

export default AppButton;