import React, { PureComponent } from "react";
import {
    View,
    StyleSheet,
    Text,
    TextInput,
    Image,
    Platform
} from "react-native";
import PropTypes from "prop-types";
import _ from "lodash";
import Metrics from "../../services/Metrics";

import { colors, UIFont, fonts, fontSize } from "../../assets";

export default class BorderInput extends PureComponent {
    static propTypes = {
        label: PropTypes.string,
        error: PropTypes.string,
        onRight: PropTypes.func,
        value: PropTypes.oneOfType([PropTypes.string, PropTypes.number])
    };

    static defaultProps = {
        label: "Enter a label",
        error: "Error",
        onRight: () => {}
    };

    constructor(props: Object, context: Object) {
        super(props, context);
        this.state = {
            val: props.value ? props.value : "",
            isError: false,
            passwordError: ""
        };
    }

    setText = txt => {
        this.onChangeText(txt);
        this.animateUp();
    };

    getValue = () => this.state.val;

    setError = (boo, val) => {
        this.props.setError && this.props.setError(true);
        this.setState({ isError: boo, passwordError: val });
    };

    setFocus = () => this.textInput.focus();

    onChangeText = val => {
        const { cbOnChangeText } = this.props;
        cbOnChangeText && cbOnChangeText(val);
        this.props.setError && this.props.setError(false);
        this.setState({ val, isError: false, passwordError: "" });
    };

    renderError() {
        let errStyle = this.props.isContainerFlex
            ? [styles.error, { marginHorizontal: 20 }]
            : styles.error;
        if (this.state.isError) {
            return (
                <Text style={errStyle}>
                    {this.state.passwordError
                        ? this.state.passwordError
                        : this.props.error}
                </Text>
            );
        }
    }
    render() {
        const {
            style = {},
            value,
            label,
            textFieldStyle,
            textFieldImage,
            rightTextFieldImage,
            isContainerFlex,
            ...rest
        } = this.props;

        const { isError } = this.state;
        return (
            <View style={isContainerFlex ? {} : styles.container}>
                <View style={[textFieldStyle]}>
                    {!_.isUndefined(textFieldImage) ? (
                        <Image
                            resizeMode="contain"
                            source={textFieldImage}
                            style={{
                                padding: Metrics.baseMargin,
                                marginLeft: Metrics.smallMargin
                            }}
                            width={Metrics.images.small}
                            height={Metrics.images.small}
                        />
                    ) : null}
                    <TextInput
                        style={[
                            styles.textInputStyle,
                            styles.textContainer,
                            style,
                            isContainerFlex ? {} : styles.containerFlex,
                            isError ? { borderColor: "#f44336" } : {}
                        ]}
                    
                        ref={ref => (this.textInput = ref)}
                        onChangeText={this.onChangeText}
                        value={this.state.val}
                        autoCapitalize="none"
                        {...rest}
                    />
                    {!_.isUndefined(rightTextFieldImage) ? (
                        <Image
                            resizeMode="contain"
                            source={rightTextFieldImage}
                            style={{}}
                            width={Metrics.images.small}
                            height={Metrics.images.small}
                        />
                    ) : null}
                </View>

                {this.renderError()}
            </View>
        );
    }
}

const styles = StyleSheet.create({
    container: {
        marginBottom: Metrics.baseMargin
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red")
    },
    containerFlex: { flex: 1 },
    textInputStyle: {
    
        ...UIFont.font(fonts.reqular, fontSize.small, "#241332"),
        paddingRight: Metrics.baseMargin,
        borderColor: 'gray',
        height:50,
        borderWidth: 1,
        letterSpacing: 0
    },


    textContainer: {
        padding: Platform.OS && 15
    }
});
