import React from "react";
import PropTypes from "prop-types";
import {
    TouchableOpacity,
    TouchableNativeFeedback,
    View,
    Platform
} from "react-native";

let disableClick = false;
let enable = true;

const debounceTime = Platform.select({
    ios: 200,
    android: 900
});
const ButtonView = (props: Object) => {
    const { onPress, children,enable, ...rest } = props;
    _onPress = () => {
        if (!disableClick) {
            disableClick = true;
            if (onPress) {
                onPress();
            }

            setTimeout(() => {
                disableClick = false;
            }, debounceTime);
        }
    };

    return (
        <TouchableOpacity  disabled ={enable}
        onPress={this._onPress} {...rest}>
            {children}
        </TouchableOpacity>
    );
};

ButtonView.propTypes = {
    enable : PropTypes.bool,
    onPress: PropTypes.func.isRequired,
    children: PropTypes.oneOfType([
        PropTypes.object,
        PropTypes.array,
        PropTypes.element
    ]).isRequired
};

export default ButtonView;
