import React from "react";
import { View, Text, StyleSheet, TouchableOpacity } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import moment from "moment";
import { getCurrentRouteName } from "../../services/NavigationService";
import Utils from "../../Utils";

const calculateDiffTime = (b, a) => {
    let dif = moment(b, "HH:mm:a").diff(moment(a, "HH:mm:a"));
    let diffTime = moment.duration(dif).hours();
    return diffTime == 0 ? 1 : diffTime;
};

const CardBottom = ({ data, cbTotal, cbMileage }) => {
    const {
        contract_type,
        project_validity,
        hourly_pay_rate,
        contract_rate,
        contract_invitations,
        amount,
        cost_per_mile,
        latitude,
        longitude,
        shift_end_time,
        shift_start_time,
        maximum_radius,
        contract_status,
        is_onboarded,
        my_earrings,
        invitation_status,
        is_mileage_paid,
        // total_hours,
        hour_rate,
        mileage_amount,
        total_amount,
        is_onboarded_contract_history,
        onboarded_contract_history,
        admin_percent
    } = data;

    let adminFee = admin_percent === undefined ? Utils.getAdminFee() : admin_percent;
    // let adminFee = Utils.getAdminFee();

    //new work
    let total_hours = data.total_hours;
    if (is_onboarded_contract_history) {
        if (contract_type === "Contract") {
            total_hours = onboarded_contract_history.total_hours;
        }
    }

    let totalRadius = maximum_radius;
    let rate = hourly_pay_rate === null
        ? contract_rate && contract_rate
        : hourly_pay_rate && hourly_pay_rate;


    let totalAmount = contract_type === "Contract" ? rate : +rate * total_hours;

    //new work
    if (contract_type === "Contract") {
        totalAmount = (rate * total_hours).toFixed(2);  
    }

    if ((getCurrentRouteName() == "onboardProjects" ||
        getCurrentRouteName() == "onboardProjectsDetail") &&
        contract_invitations !== undefined &&
        contract_invitations[0] !== undefined &&
        contract_invitations[0].invitation_latitude !== null) {

        let dist = Utils.distance(
            latitude,
            longitude,
            contract_invitations[0].invitation_latitude,
            contract_invitations[0].invitation_longitude
        );
        totalRadius = dist > maximum_radius ? maximum_radius : dist;
        if (contract_invitations[0].bid_amount !== null &&
            contract_invitations[0].bid_amount !== "0.00" &&
            contract_invitations[0].bid_amount > 0) {

            rate = contract_type === "Contract"
                ? contract_invitations[0].bid_amount 
                : contract_invitations[0].bid_amount / total_hours;
            // totalAmount = contract_invitations[0].bid_amount; //old
            totalAmount = (rate * total_hours).toFixed(2);
        }

    } else if (getCurrentRouteName() == "myScheduleDetail" &&
        contract_invitations !== undefined && Array.isArray(contract_invitations)) {

        let dist = Utils.distance(
            contract_invitations[0].latitude,
            contract_invitations[0].longitude,
            contract_invitations[0].invitation_latitude,
            contract_invitations[0].invitation_longitude);
        totalRadius = dist > maximum_radius ? maximum_radius : dist;
        if (contract_invitations[0].bid_amount !== null &&
            contract_invitations[0].bid_amount !== "0.00") {

            rate = contract_type === "Contract"
                ? contract_invitations[0].bid_amount  / total_hours
                : contract_invitations[0].bid_amount / total_hours;
            totalAmount = contract_invitations[0].bid_amount;
        }

    } else if ((getCurrentRouteName() == "myEarnings" ||
        getCurrentRouteName() == "mySchedule" ||
        getCurrentRouteName() == "myScheduleDetail") &&
        contract_invitations !== undefined) {

        let dist = Utils.distance(
            contract_invitations.latitude,
            contract_invitations.longitude,
            contract_invitations.invitation_latitude,
            contract_invitations.invitation_longitude
        );
        totalRadius = dist > maximum_radius ? maximum_radius : dist;
        if (contract_invitations.bid_amount !== null &&
            contract_invitations.bid_amount !== "0.00" &&
            contract_invitations.bid_amount > 0) {

            rate = contract_type === "Contract"
                ? contract_invitations.bid_amount 
                : contract_invitations.bid_amount / total_hours;

            totalAmount = rate * total_hours;

            totalAmount = contract_status == "close"
                ? Utils.getUserType() == "Contractor" ? totalAmount : 
                ((adminFee / 100) * totalAmount + totalAmount)
                : totalAmount.toFixed(2);

   
        } else {
            totalAmount = contract_type == "Contract"
                ? contract_status == "close" ?
                    Utils.getUserType() == "Contractor" ? totalAmount : ((adminFee / 100) * totalAmount + totalAmount) 
                    : totalAmount
                : contract_status == "close"
                    ? totalAmount + totalRadius * +cost_per_mile
                    : totalAmount;
        }

        //new work
        if (is_onboarded_contract_history) {
            if (contract_type === "Shift") {

                Utils.getUserType() == "Contractor"
                    ?
                    totalAmount = onboarded_contract_history.total_amount
                    :
                    // totalAmount = onboarded_contract_history.total_amount;
                    totalAmount = ((adminFee / 100) * +onboarded_contract_history.total_amount + +onboarded_contract_history.total_amount).toFixed(2);

                    

            }
        }
    } else if ((getCurrentRouteName() == "myShiftsContracts" && contract_status == "close") ||
        (getCurrentRouteName() == "detailScreen" && contract_status == "close")) {

        if (contract_invitations[0] !== undefined) {
            let dist = Utils.distance(
                latitude,
                longitude,
                contract_invitations[0].invitation_latitude,
                contract_invitations[0].invitation_longitude
            );
            totalRadius = dist > maximum_radius ? maximum_radius : dist;
            if (contract_invitations[0].bid_amount !== null &&
                contract_invitations[0].bid_amount !== "0.00" &&
                contract_invitations[0].bid_amount > 0) {

                rate = contract_type === "Contract" ? contract_invitations[0].bid_amount / total_hours
                    : is_mileage_paid ?
                        contract_invitations[0].bid_amount / total_hours
                        : contract_invitations[0].bid_amount / total_hours;

                totalAmount = rate * total_hours;

                totalAmount = contract_type === "Contract"
                    ? (adminFee / 100) * +totalAmount + +totalAmount
                    : ((adminFee / 100) * (totalRadius * +cost_per_mile) +
                        +contract_invitations[0].bid_amount + totalRadius * +cost_per_mile).toFixed(2);



            } else {
                totalAmount = contract_type == "Contract"
                    ? (adminFee / 100) * +totalAmount + +totalAmount
                    : ((adminFee / 100) * (totalAmount + totalRadius * +cost_per_mile) +
                        +totalAmount + totalRadius * +cost_per_mile).toFixed(2);


            }
        }

        //new work

        if (is_onboarded_contract_history) {


            if (contract_type === "Shift") {

                totalAmount = ((adminFee / 100) * +onboarded_contract_history.total_amount + +onboarded_contract_history.total_amount).toFixed(2);

            }
        }
    }
    else{

       
 
    }

    return (
        <React.Fragment>
            <View style={styles.container}>
                <View
                    style={[
                        styles.eachView,
                        {
                            width:
                                contract_type === "Shift" &&
                                    cost_per_mile == null
                                    ? "32%"
                                    : "22%"
                        }
                    ]}
                >
                    <Text style={styles.firstText}>Category</Text>
                    <Text
                        style={[
                            styles.txtContract,
                            {
                                color:
                                    contract_type === "Contract"
                                        ? colors.RedColor
                                        : colors.btnActive
                            }
                        ]}
                    >
                        {contract_type}
                    </Text>
                </View>
                <View
                    style={[
                        styles.eachView,
                        {
                            width:
                                contract_type === "Shift" &&
                                    cost_per_mile == null
                                    ? "32%"
                                    : "19%"
                        }
                    ]}
                >
                    <Text style={styles.firstText}>
                        {contract_type === "Contract" ? "Hour Rate" : "Per hour"}
                    </Text>
                    <Text style={styles.txtContract}>${hour_rate}</Text>
                </View>

                {!(contract_type === "Shift" && cost_per_mile == null) && (
                    <TouchableOpacity
                        onPress={cbMileage}
                        style={[styles.eachView, { width: "31%" }]}
                    >
                        <Text style={styles.firstText}>
                            {contract_type === "Contract"
                                ? "Project Validity":
                                //  getCurrentRouteName() == "myScheduleDetail" ||
                                    // getCurrentRouteName() ==
                                    // "onboardProjectsDetail" ||
                                    getCurrentRouteName() == "myEarnings" ||
                                    // getCurrentRouteName() == "mySchedule" ||
                                    // getCurrentRouteName() == "onboardProjects" ||
                                    ((getCurrentRouteName() ==
                                        "myShiftsContracts" ||
                                        getCurrentRouteName() ==
                                        "detailScreen") &&
                                        contract_status == "close")
                                    ? "Mileage Paid"
                                    : `Upto ${maximum_radius} miles`}
                        </Text>
                        <Text style={styles.txtContract}>
                            {contract_type === "Contract"
                                ? project_validity:
                                // : getCurrentRouteName() === "onboardProjects" ||
                                    // getCurrentRouteName() === "onboardProjectsDetail" ||
                                    // getCurrentRouteName() === "mySchedule" ||
                                    // getCurrentRouteName() === "myScheduleDetail" ||
                                    ((getCurrentRouteName() == "myShiftsContracts" ||
                                        getCurrentRouteName() == "detailScreen") &&
                                        contract_status == "close")
                                     ? `$${(+mileage_amount).toFixed(1)}`
                                    // `$${(+cost_per_mile * +totalRadius).toFixed(1)}`
                                    : `$${(+cost_per_mile).toFixed(1)}`}
                        </Text>
                    </TouchableOpacity>
                )}

                <TouchableOpacity
                    onPress={cbTotal}
                    style={[
                        styles.eachView,
                        {
                            width:
                                contract_type === "Shift" &&
                                    cost_per_mile == null
                                    ? "32%"
                                    : "22%"
                        }
                    ]}>
                    <Text style={styles.firstText}>Total</Text>
                    <Text style={styles.txtContract}>{"$" + parseFloat(total_amount).toFixed(2)}</Text>
                </TouchableOpacity>
                
            </View>
            {!( cost_per_mile == null) && (
                    <View style={[styles.containerhour, { marginTop: 5 }]}>
                        {getCurrentRouteName() == "onboardProjectsDetail" ||
                            getCurrentRouteName() == "myScheduleDetail" ? (
                            <View
                                style={[
                                    styles.eachView,
                                    {
                                        width: "32%"
                                    }
                                ]}
                            >
                                <Text style={styles.firstText}>Hour Total</Text>
                                <Text
                                    style={[
                                        styles.txtContract,
                                        {
                                            color: "black"
                                        }
                                    ]}
                                >
                                    ${(hour_rate* total_hours).toFixed(1)}
                                </Text>
                            </View>
                        ) : null}
                        
                        {getCurrentRouteName() == "onboardProjectsDetail" ||
                            getCurrentRouteName() == "myScheduleDetail" ? (
                            <View
                                style={[styles.eachView, { width: "32%" }]}>
                                <Text style={styles.firstText}>Mileage Paid</Text>
                                <Text style={[styles.txtContract, { color: "black" }]}> ${mileage_amount}</Text>
                            </View>
                        ) : null}

                        {/* <View style={[styles.eachView, { width: "32%" }]}>
                            <Text style={styles.firstText}>
                                {getCurrentRouteName() == "myShiftsContracts" ||
                                    getCurrentRouteName() == "detailScreen"
                                    ? null
                                    : null}
                            </Text>
                            <Text
                                style={[
                                    styles.txtContract,
                                    {
                                        color: "black"
                                    }
                                ]}
                            >
                                ${my_earrings.contractor_amount}
                            </Text>
                        </View> */}
                    </View>
                )}
            {invitation_status !== "rejected" &&
                contract_status == "close" &&
                is_onboarded === 1 &&
                my_earrings !== undefined && (
                    <View style={[styles.container, { marginTop: 5 }]}>
                        {getCurrentRouteName() == "myShiftsContracts" ||
                            getCurrentRouteName() == "detailScreen" ? (
                            <View
                                style={[
                                    styles.eachView,
                                    {
                                        width: "32%"
                                    }
                                ]}
                            >
                                <Text style={styles.firstText}>Admin Fee</Text>
                                <Text
                                    style={[
                                        styles.txtContract,
                                        {
                                            color: "black"
                                        }
                                    ]}
                                >
                                    ${my_earrings.admin_percent}
                                </Text>
                            </View>
                        ) : null}
                        {getCurrentRouteName() == "myShiftsContracts" ||
                            getCurrentRouteName() == "detailScreen" ? (
                            <View
                                style={[styles.eachView, { width: "32%" }]}>
                                <Text style={styles.firstText}>Stripe Fee</Text>
                                <Text style={[styles.txtContract, { color: "black" }]}> 
                                ${my_earrings.stripe_fee}
                                </Text>
                            </View>
                        ) : null}

                        <View style={[styles.eachView, { width: "32%" }]}>
                            <Text style={styles.firstText}>
                                {getCurrentRouteName() == "myShiftsContracts" ||
                                    getCurrentRouteName() == "detailScreen"
                                    ? "Clinician"
                                    : "Earning"}
                            </Text>
                            <Text
                                style={[
                                    styles.txtContract,
                                    {
                                        color: "black"
                                    }
                                ]}
                            >
                                ${my_earrings.contractor_amount}
                            </Text>
                        </View>
                    </View>
                )}
        </React.Fragment>
    );
};

const styles = StyleSheet.create({
    container: {
        flexDirection: "row",
        justifyContent: "space-between"
    },
    containerhour: {
        flexDirection: "row",
        justifyContent: "space-around"
    },
    eachView: {
        borderRadius: 5,
        borderStyle: "solid",
        borderWidth: 1,
        borderColor: "#dde3f6",
        alignItems: "center",
        justifyContent: "center",
        height: 40
    },
    firstText: {
        ...UIFont.font(fonts.regular, 9, colors.CardDate),
        lineHeight: 11,
        letterSpacing: 0
    },
    secondText: {
        ...UIFont.font(fonts.regular, 16, colors.CardDate),
        lineHeight: 19,
        letterSpacing: 0
    },
    txtContract: {
        ...UIFont.font(fonts.semiBold, 12, colors.CardDate)
    }
});

export default CardBottom;
