import React from "react";
import { View, Text, StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";

const CardStatus = ({ label, style }) => {
    return (
        <View style={[styles.container, style]}>
            <Text style={styles.statusText}>{label}</Text>
        </View>
    )
}

const styles = StyleSheet.create({
    container: {
        borderRadius: 5,
        width: '100%',
        height: 40, 
        justifyContent: 'center', 
        alignItems: 'center'
    },
    statusText: {
        ...UIFont.font(fonts.semiBold, fontSize.xSmall, colors.cardColor),       
        // lineHeight: 11,
        // letterSpacing: 0.5,
    }
})

export default CardStatus;
