import React from "react";
import { View, Text, StyleSheet, Image } from "react-native";
import { colors, UIFont, fonts, fontSize, Images } from "../../assets";
import { IMAGE_BASE_URL } from "../../services/WebService";

RateLabel = rate => {
    return (
        <View style={styles.rateLabel}>
            <Image source={Images.img_star} />
            <Text style={styles.rateStyle}>{rate}</Text>
        </View>
    );
};

CommentCard = ({ data }) => {
    let item = data.item;
    if (item.comments == null) return null;

    return (
        <View
            style={{
                flexDirection: "row",
                marginVertical: 10,
                marginHorizontal: 10
            }}
        >
            <View style={{ flex: 1 }}>
                <View style={styles.cardImage}>
                    <View elevation={15}>
                        <Image
                            source={{
                                uri: `${IMAGE_BASE_URL}/${
                                    item.rejected_user_image_url
                                        ? item.rejected_user_image_url
                                        : item.image_url
                                }`
                            }}
                            resizeMode="cover"
                            style={styles.imgStyle}
                        />
                    </View>
                </View>
            </View>
            <View style={{ flex: 4 }}>
                <View style={{ flex: 1, flexDirection: "row" }}>
                    <View style={{ flexDirection: "row", flex: 1 }}>
                        <Text style={styles.titleStyle}>
                            {item.user_full_name || item.comment_full_name}
                        </Text>
                        {/*RateLabel(item.comment_rating)*/}
                    </View>
                    <Text style={styles.sinceTextStyle}>
                        {item.created_at || item.created_since}
                    </Text>
                </View>
                <View style={{ flex: 3 }}>
                    <Text style={styles.msgTextStyle}>
                        {item.comments || item.message}
                    </Text>
                </View>
            </View>
        </View>
    );
};

const styles = StyleSheet.create({
    imgStyle: {
        width: 60,
        height: 60,
        borderRadius: 30,
        borderColor: colors.WhiteColor,
        borderWidth: 2,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        padding: 5,
        alignSelf: "flex-end"
    },
    cardImage: {
        flex: 1,
        alignSelf: "flex-start"
    },
    msgTextStyle: {
        ...UIFont.font(fonts.regular, 11, colors.InActiveTabTitle)
    },
    sinceTextStyle: {
        ...UIFont.font(fonts.regular, 11, "#5f5f5f"),
        textAlign: "right"
    },
    titleStyle: {
        ...UIFont.font(fonts.semiBold, 20, colors.BlackColor)
    },
    rateLabel: {
        width: 30,
        flexDirection: "row",
        marginTop: 5,
        marginLeft: 5
    },
    rateStyle: {
        ...UIFont.font(fonts.regular, 13, colors.BlackColor),
        paddingHorizontal: 3
    }
});

export default CommentCard;
