import React, { Component } from "react";
import { StyleSheet, View, } from "react-native";
import { colors } from "../../assets";
import { Metrics } from "../../theme";

class Container extends Component {

    render() {
        const { children, style } = this.props;
        return (
            <View style={[styles.container, style]}>
                {children}
            </View>
        );
    }
}
const styles = StyleSheet.create({
    container: {
        flex: 1,
        height: Metrics.isPlatform === 'ios' ? Metrics.screenHeight : Metrics.screenHeight - 20,
        backgroundColor: colors.background
    }
});

export default Container;