import React, { Component } from "react";
import { View, StyleSheet, Text, Image, TouchableOpacity } from "react-native";
import DatePicker from "react-native-datepicker";
import Colors from "../../services/Colors";
import { UIFont, fonts, fontSize } from "../../assets";
import Utils from "../../Utils";

const DateTimePicker = ({
    style,
    date,
    dateTime,
    title,
    onChangeState,
    stateName,
    isError = false,
    error,
    editable,
    minDate,
    maxDate
}) => {
    const { dateInput, dateText, datePickerStyle, disabledColor } = style;
    return (
        <View style={{ paddingTop: 10 }}>

                 <DatePicker
                style={datePickerStyle}
                date={date}
                mode={dateTime}
                disabled={editable}
                placeholder={title}
                placeholderText={Colors.textfieldBorder}
                format="YYYY-MM-DD"
                minDate={minDate}
                maxDate={maxDate}
                confirmBtnText="Confirm"
                cancelBtnText="Cancel"
                showIcon={false}
                customStyles={{ dateInput, dateText, disabled: disabledColor }}
                onDateChange={date => {
                    onChangeState({ [stateName]: date });
                }}
            />
            
            {isError && <Text style={styles.error}>{error}</Text>}
        </View>
    );
};

const styles = StyleSheet.create({
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start",
        paddingHorizontal: 20
    }
});

export default DateTimePicker;
