import React, { Component } from "react";
import { View, StyleSheet, Text, Image, TouchableOpacity } from "react-native";
import Colors from "../../services/Colors";
import { UIFont, fonts, fontSize } from "../../assets";
import DateTimePicker from '@react-native-community/datetimepicker';

const DateTimePickerAndroid = ({
    style,
    date,
    dateTime,
    title,
    onChangeState,
    stateName,
    isError = false,
    error,
    editable,
    minDate,
    maxDate
}) => {
    const { dateInput, dateText, datePickerStyle, disabledColor } = style;
    return (
        <View style={{ paddingTop: 10 }}>
            <DateTimePicker
                style={datePickerStyle}
                date={date}
                mode={dateTime}
                value={new Date()}
                format="YYYY-MM-DD"
                minimumDate={minDate}
                maximumDate={maxDate}
                confirmBtnText="Confirm"
                cancelBtnText="Cancel"
                showIcon={false}
                customStyles={{ dateInput, dateText, disabled: disabledColor }}
                onChange={date => {
                    onChangeState({ [stateName]: date });
                }}
            />
          

            {isError && <Text style={styles.error}>{error}</Text>}
        </View>
    );
};

const styles = StyleSheet.create({
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start",
        paddingHorizontal: 20
    }
});

export default DateTimePicker;
