import React, { Component } from "react";
import { View, StyleSheet, Text, Image } from "react-native";
import { colors, UIFont, fonts, fontSize, Images } from "../../assets";
import CardBottom from "../CardBottom";
import CardStatus from "../CardStatus";
import TextLabel from "../Text";
import { IMAGE_BASE_URL } from "../../services/WebService";
import { getCurrentRouteName } from "../../services/NavigationService";
import moment from "moment";
import Utils from "../../Utils";

//Detail page card
const CardTitle = (
    {
        category_name: cardTitle = "",
        description: cardText = "",
        contract_status,
        is_onboarded,
        is_marked
    },
    { full_name: hospitalName = "" },
    pending
) => {
    let boo =
        getCurrentRouteName() == "requestsDetail" || "onboardProjectsDetail";
    return (
        <View style={styles.cardTitle}>
            <View style={{ flex: 2 }}>
                <Text style={styles.cardTitleText}>{cardTitle}</Text>
                <Text style={styles.cardTitleText2}>
                    {boo ? "" : hospitalName}
                </Text>
            </View>
            <View style={styles.cardTitleRight}>
                {!pending ? (
                    <CardStatus
                        label={
                            is_onboarded && contract_status === "active"
                                ? is_marked === 1 ? "PENDING APPROVAL" : "ONBOARD"
                                : contract_status === "active"
                                    ? "Active"
                                    : "Closed"
                        }
                        style={{
                            backgroundColor:
                                is_onboarded && contract_status === "active"
                                    ? "#fcb801"
                                    : contract_status === "active"
                                        ? colors.btnActive
                                        : colors.InActiveTabTitle
                        }}
                    />
                ) : (
                    <Text
                        style={
                            pending == "Rejected"
                                ? styles.RejectText
                                : styles.pendingText
                        }
                    >
                        {pending}
                    </Text>
                )}
            </View>
        </View>
    );
};

const RateLabel = rate => {
    return (
        <View style={styles.rateView}>
            <Image source={Images.img_star} />
            <Text style={styles.rateStyle}>{rate}</Text>
        </View>
    );
};

const CardDateTime = (item) => {

    const {
        is_onboarded_contract_history, onboarded_contract_history, shift_start_date, shift_end_date,
        shift_start_time, shift_end_time, contract_type, rating, total_hours, is_covid } = item;

    let end_date = shift_end_date;
    let start_date = shift_start_date;
    let start_time = shift_start_time;
    let end_time = shift_end_time;

    if (is_onboarded_contract_history) {

        if (contract_type === 'Shift') {
            start_time = onboarded_contract_history.shift_start_time
            end_time = onboarded_contract_history.shift_end_time
        }
    }

    return (
        <View style={{ flex: 2.5, flexDirection: "column" }}>
            {contract_type == "Contract" && (
                <Text
                    style={styles.cardDate}
                >{`${start_date} to ${end_date}`}</Text>
            )}
            <View style={{ flexDirection: "row", flex: 1, justifyContent: "space-between" }}>
                <Text style={styles.cardDate}>{`Shift Hours : ${Utils.ShowDifftimeHour(end_time, start_time)} hrs`}</Text>
                {rating > 0 ? RateLabel(rating) : null}
            </View>
            <Text style={styles.cardDate}>
                {contract_type !== "Contract" && start_date}(
                {`${start_time} to ${end_time}`})
            </Text>

            {is_covid == "yes" ?
                <Text
                    style={[
                        styles.cardDate,
                        {
                            color: colors.btnActive
                        }
                    ]}>

                    {contract_type === "Contract"
                        ? " Covid Contract"
                        : "Covid Shift"}


                </Text>
                : null}

        </View>
    );
};

const CardGap = obj => <View style={obj} />;

const CardTop = (data, user, pending) => {
    let boo =
        getCurrentRouteName() == "requestsDetail" ||
        getCurrentRouteName() == "onboardProjectsDetail" ||
        getCurrentRouteName() == "detailScreen";
    return (
        <View style={styles.upperRow}>
            <Image
                source={{
                    uri: `${IMAGE_BASE_URL}${boo ? user.image_url : data.image_url
                        }`
                }}
                // source={Images.dummyImages[Math.round(Math.random() * 2)]}
                style={styles.imgStyle}
            />
            <View style={styles.besideImg}>
                {CardTitle(data, user, pending)}
                {/*CardGap({ flex: 1.5 })*/}
                {CardDateTime(data)}
            </View>
        </View>
    );
};

const DetailCard = ({
    data,
    user = {},
    style = {},
    pending,
    cbTotal = null,
    cbMileage = null
}) => {

    let signature_Verify = data.title == null || data.name == null ? "Signature Not Verified" : "Signature Verified";
    let color_sign = data.title == null || data.name == null ? "no" : "yes";

    let location_Verify = data.is_location_matched == 2 ? "Location Matched" : "Location Not Matched";
    let color_loc = data.is_location_matched == 2 ? "yes" : "no";


    return (
        <View style={[styles.container, style]}>
            {CardTop(data, user, pending)}
            {<CardBottom data={data} cbTotal={cbTotal} cbMileage={cbMileage} />}

            {data.contract_status === "active" ? null :
                <View style={{ flexDirection: "row", }}>

                    {data.lunch_break == "yes" ?
                        <View style={[styles.eachView, { width: "32%" }]}>
                            <Text style={styles.firstText}>
                                {"Lunch Taken"}
                            </Text>
                            <Text
                                style={[
                                    styles.txtContract,
                                    {
                                        color: "black"
                                    }
                                ]}
                            >
                                {`${Utils.convertminutesTOhour(data.lunch_break_time)}`}
                            </Text>
                        </View> : null}

                    {data.title == undefined ? null :
                        <CardStatus
                            label={signature_Verify}
                            style={{
                                backgroundColor: color_sign == "no" ?
                                    "#c95454" : "#33be57",
                                //backgroundColor: "#33be57",
                                width: 100,
                                margin: 5,
                                fontSize: 5,
                                padding: 5
                            }}
                        />}

                    {data.is_location_matched == undefined ? null :
                        <CardStatus
                            label={location_Verify}
                            style={{
                                //backgroundColor: "#33be57",
                                backgroundColor: color_loc == "no" ? "#c95454" : "#33be57",
                                width: 100,
                                margin: 5,
                                padding: 5,
                                ...UIFont.font(fonts.regular, fontSize.small),
                            }}
                        /> }


                </View>

            }
            {data.contract_status === "active" ? null :

                data.lunch_break != null ?
                    <View>

                        {data.lunch_break == "no" ?
                            <View>
                                <TextLabel
                                    type="medium"
                                    size="medium"
                                    color={"black"}
                                    style={styles.boldText}>

                                    {"Lunch Not Taken Reason"}
                                </TextLabel>
                                <Text style={styles.cardDate}>

                                    {data.lunch_break_reason}
                                </Text>

                            </View>

                            : null
                        }
                    </View>
                    : null
            }
        </View>
    );
};
const styles = StyleSheet.create({
    container: {
        margin: 10,
        backgroundColor: "#f8f8f8",
        flexDirection: "column",
        padding: 12
    },
    upperRow: {
        flexDirection: "row",
        marginBottom: 10
    },
    imgStyle: {
        width: 90,
        height: 90,
        borderRadius: 5
    },
    besideImg: {
        paddingLeft: 10,
        paddingTop: 5,
        flex: 1,
        flexDirection: "column"
    },
    txtContract: {
        ...UIFont.font(fonts.semiBold, 12, colors.CardDate)
    },
    eachView: {
        borderRadius: 5,
        borderStyle: "solid",
        borderWidth: 1,
        borderColor: "#dde3f6",
        alignItems: "center",
        justifyContent: "center",
        height: 40,
        marginTop: 5
    },
    firstText: {
        ...UIFont.font(fonts.regular, 9, colors.CardDate),
        lineHeight: 11,
        letterSpacing: 0
    },
    cardTitle: {
        flex: 2,
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center"
    },
    cardTitleText: {
        ...UIFont.font(fonts.semiBold, fontSize.medium, colors.ActiveTabTitle),
        letterSpacing: 0
    },
    boldText: {
        ...UIFont.font(fonts.regular, 16, colors.ActiveTabTitle),
        marginTop: 10,
        marginBottom: 10,
        alignSelf: "flex-start",
        lineHeight: 16,
        letterSpacing: 0
    },
    cardTitleText2: {
        ...UIFont.font(fonts.regular, 10, colors.ActiveTabTitle),
        letterSpacing: 0
    },
    cardTitleRight: {
        flexDirection: "column",
        justifyContent: "space-between",
        alignItems: "center",
        flex: 1.2
    },
    cardDate: {
        ...UIFont.font(fonts.regular, 12, colors.CardDate),
        lineHeight: 17,
        letterSpacing: 0
    },
    cardTime: {
        ...UIFont.font(fonts.regular, 11, colors.CardDate),
        lineHeight: 13,
        letterSpacing: 0
    },
    pendingText: {
        ...UIFont.font(fonts.regular, 14, "#41da8a")
    },
    RejectText: {
        ...UIFont.font(fonts.regular, 14, "red")
    },
    rateStyle: {
        ...UIFont.font(fonts.regular, 10, colors.cardColor)
    },
    rateView: {
        width: 30,
        height: 15,
        backgroundColor: "#8F2322",
        position: "absolute",
        top: 0,
        right: 0,
        borderRadius: 2,
        justifyContent: "center",
        alignItems: "center",
        flexDirection: "row"
    }
});

export default DetailCard;
