import React, { Component, Fragment } from "react";
import {
    View,
    StyleSheet,
    Platform,
    Text,
    TextInput,
    ScrollView,
    Image,
    Linking,
    TouchableOpacity
} from "react-native";
import _ from "lodash";
import DocumentPicker from "react-native-document-picker";
import MediaPicker from "../../services/MediaPicker";
import { Images, colors, UIFont, fonts, fontSize, icons } from "../../assets";
import { TextLabel, ButtonView, DateTimePicker } from "../";
import Colors from "../../services/Colors";
import Metrics from "../../services/Metrics";
import { IMAGE_BASE_URL } from "../../services/WebService";
import CImage from "../Image";
import moment from "moment";
import Utils from "../../Utils";
import DateTime from '@react-native-community/datetimepicker';
import { UPLOAD_TYPE_IMAGE, UPLOAD_TYPE_DOC } from "../../constants";
const centerAligned = { alignItems: "center", justifyContent: "center" };
import ImageViewer from "../ImageViewer";

class DocumentImages extends Component {

    constructor(props) {
        super(props);

        this.state = {
            showdate: false,
            expiredate: ''
        }
    };
    shouldComponentUpdate(nextProps, nextState) {
        return (
            !_.isEqual(this.state, nextState) ||
            !_.isEqual(this.props, nextProps)
        );
    }

    onImagePicked = (uri, imageObj, str, index) => {
        this.onImageResize(uri, index, "image");
    };

    pushImageOrDocToState = (obj, index, type) => {
        const { images } = this.props.data;
        const tempImages = _.cloneDeep(images);



        type === "pdf" ? (tempImages[index] = {
            ...tempImages[index],
            images: [...tempImages[index].images, obj[0]],
            isError: false
        }
        ) : (
            tempImages[index] = {
                ...tempImages[index],
                images: [...tempImages[index].images, obj.uri],
                isError: false
            }
        )

        this.props.onChangeState(tempImages);
    };

    onImageResize = (uri, index, type) => {
        MediaPicker.resizeImage(uri)
            .then(imageObj => {
                this.pushImageOrDocToState(
                    { ...imageObj, type: UPLOAD_TYPE_IMAGE },
                    index,
                    type
                );
            })
            .catch(err => console.log("err : ", err));
    };

    onPickDoc = async (index, type) => {
        // Pick a single file
        try {
            const docObj = await DocumentPicker.pick({
                type: [DocumentPicker.types.pdf]
            });
            this.pushImageOrDocToState(
                { ...docObj, type: UPLOAD_TYPE_DOC },
                index,
                type
            );
        } catch (err) {
            if (DocumentPicker.isCancel(err)) {

            }

        }
    };



    onImageAdd = (str, index, type) => ev => {
        const { images } = this.props.data;
        type === "pdf"
            ? this.onPickDoc(index, type)
            : MediaPicker.showPicker((uri, imageObj) =>
                this.onImagePicked(uri, imageObj, str, index)
            );
    };

    onImageRemove = (parentArrayIndex, title, childArrayIndex) => ev => {
        const { images } = this.props.data;
        let tempImages = _.cloneDeep(images);
        const splicedItem = tempImages[parentArrayIndex].images.splice(
            childArrayIndex,
            1
        );
        this.props.onChangeState(tempImages, splicedItem);
    };

    labelText = (label, topMargin = {}) => {
        return (
            <TextLabel color={"black"} style={[styles.textLabel, topMargin]}>
                {label}
            </TextLabel>
        );
    };

    renderError(err, obj) {
        if (this.props.data.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }

    datePicker(title, icon, dateTime) {
        const { dateInput, dateText, datePickerStyle } = styles;
        return (
            <DateTimePicker
                style={{ dateInput, dateText, datePickerStyle }}
                date={this.props.data.expiryDate}
                dateTime={dateTime}
                title={title}
                minDate={moment().format("YYYY-MM-DD")}
                isError={this.props.data.isError && !this.props.data.expiryDate}
                stateName={"expiryDate"}
                error={"Expiry Date is required"}
                onChangeState={({ expiryDate }) =>
                    this.props.cbOnDateChange(expiryDate)
                }
            />
        );
    }

    datePickerandorid() {

        return (

            <View>

                <DateTime
                    style={{
                        borderBottomWidth: 1,
                        borderColor: Colors.textfieldBorder,
                        width: Platform.OS ? 345 : 350
                    }}
                    //  date={this.props.data.expiryDate}
                    mode={'date'}
                    dateFormat="YYYY-MM-DD"
                    minimumDate={new Date()}
                    // maximumDate={new Date(moment().subtract(20, "years"))}
                    value={new Date()}
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"
                    is24Hour={true}
                    // onError={"Expiry Date is required"}
                    customStyles={{
                        dateInput: {
                            borderWidth: 0,
                            justifyContent: "flex-start",
                            alignItems: "flex-start",
                            paddingTop: 6,
                            paddingLeft: 10
                        },
                        dateText: {
                            color: "#241332"
                        }
                    }}
                    onChange={this.handleChangeAndroid}

                />


            </View>
        );
    }

    handleChangeAndroid = (event, selectedDate) => {


        if (event.type == "set") {
            //ok button clicked

            this.setState({ showdate: false });

            const dateset = moment(selectedDate).format("YYYY-MM-DD");
    
            this.setState({ expiredate: dateset });
    
            this.props.cbOnDateChange(dateset)

        } else {
            //cancel button clicked

            this.setState({ showdate: false });


        }

    }

    render() {
        // same screen is being used to show data on the other app so using
        // showLicenceAndDeleteIcons bool to restrict some functionality
        const {
            images,
            showLicenceAndDeleteIcons,
            downLoadClinicianDocuments
        } = this.props.data;

        let collectedImages = [];

        if (!showLicenceAndDeleteIcons) {
            images.map(
                (cat, index) =>
                    cat.title !== images[images.length - 1].title &&
                    (collectedImages = [...collectedImages, ...cat.images])
            );
        }

        return (
            <ScrollView contentContainerStyle={styles.topContainer}>
                {this.props.showLicenceAndDeleteIcons
                    ? this.labelText("Certificate/License Expiration")
                    : null}
                {this.props.showLicenceAndDeleteIcons
                    ? Utils.isPlatformAndroid() ?
                        <TouchableOpacity style={styles.viewstyle}
                            onPress={val => {
                                this.setState({ showdate: !this.state.showdate });
                            }}>

                            <View style={styles.passwordContainer}>
                                <TextInput
                                    style={styles.inputStyle}
                                    editable={false}
                                    selectTextOnFocus={false}
                                    placeholder="Expiry Date"
                                    value={this.props.data.expiryDate}
                                />
                                <Image style={styles.ImageStyle}
                                    source={icons.reg_calendar}
                                    size={10}
                                />
                            </View>
                        </TouchableOpacity> :
                        this.datePicker("Expiry Date",
                            icons.ic_expand, "date")
                    : null}

                {(this.props.data.isError || !this.props.data.expiryDate >= moment().format("YYYY-MM-DD")) &&
                    this.renderError(
                        !this.props.data.expiryDate
                            ? "Expiry Date is required"
                            : null,
                        {}
                    )}

                {this.state.showdate == false ? null : this.datePickerandorid()}

                {images.map(({ images, title, isError, source_type }, index) => (
                    <Fragment key={`${title}_${index}`}>
                        {this.labelText(title, { marginTop: 10 })}
                        {this.licenceAndOtherDocumentImages(
                            images,
                            index,
                            title,
                            source_type
                        )}
                        {isError && (
                            <TextLabel color={"red"} style={styles.error}>
                                {`${title} is required`}
                            </TextLabel>
                        )}
                    </Fragment>
                ))}

                {!showLicenceAndDeleteIcons &&
                    !!this.props.downLoadClinicianDocuments ? (
                    <TouchableOpacity
                        onPress={() =>
                            this.downLoadDocuments(
                                this.props.downLoadClinicianDocuments
                            )
                        }
                    >
                        <Text style={{ color: "blue", marginVertical: 20 }}>
                            Download Clinician Documents
                        </Text>
                    </TouchableOpacity>
                ) : null}
            </ScrollView>
        );
    }

    licenceAndOtherDocumentImages = (images, parentArrayIndex, title, source_type) => (
        <View style={styles.containerImages}>
            {images.map((item, childArrayIndex) =>
                this.renderImages(
                    { item, parentArrayIndex, childArrayIndex },
                    title, source_type
                )
            )}
        </View>
    );

    downLoadDocuments = url => {
        Linking.openURL(`${IMAGE_BASE_URL}${url}`).catch(err =>
            console.error("error opening url : ", err)
        );
    };

    renderImages = ({ item, parentArrayIndex, childArrayIndex }, title, source_type) => {
        const { showLicenceAndDeleteIcons } = this.props;
        let imageViewerModal = "imageViewerModal" + [item.id];

        if (typeof item.uri !== "string") {
            return (
                <View
                    style={[styles.imageAlignmentWrapper]}
                    key={`${item.uri}_${parentArrayIndex}`}
                >
                    <ButtonView
                        style={styles.imageAdderContainer}
                        onPress={this.onImageAdd(title, parentArrayIndex, source_type)}
                    >
                        <Image
                            source={item.uri}
                            style={{ width: "100%", height: "100%" }}
                            resizeMode={"stretch"}
                        />
                    </ButtonView>
                </View>
            );
        } else {
            return (
                <View
                    style={styles.imageAlignmentWrapper}
                    key={`${item.uri}_${parentArrayIndex}`}
                >
                    <View style={styles.imageContainer}>
                        {source_type == "pdf" ? (
                            <ButtonView
                                onPress={() => {
                                    if (!showLicenceAndDeleteIcons) {
                                        this.downLoadDocuments(item.uri);
                                    }
                                }}
                            >
                                <View style={styles.pdfContainer}>
                                    <View style={styles.rowCon}>
                                        <Image
                                            source={icons.file}
                                            style={styles.icFile}
                                        />
                                        <View style={styles.pdfSeparator} />
                                        <Text style={styles.txtPDF}>PDF</Text>
                                    </View>
                                </View>
                            </ButtonView>
                        ) : (
                            <>
                                <ButtonView
                                    onPress={() =>
                                        !showLicenceAndDeleteIcons
                                            ? imageViewerModal.show()
                                            : null
                                    }
                                >
                                    <CImage
                                        style={styles.pickedImage}
                                        placeholderStyle={[
                                            styles.pickedImage,
                                            { resizeMode: "contain" }
                                        ]}
                                        source={
                                            item.uri.slice(0, 4) === "file"
                                                ? { uri: item.uri }
                                                : {
                                                    uri:
                                                        IMAGE_BASE_URL +
                                                        item.uri
                                                }
                                        }
                                    />
                                </ButtonView>
                                {!showLicenceAndDeleteIcons && (
                                    <ImageViewer
                                        images={[
                                            {
                                                url: `${IMAGE_BASE_URL}${item.uri}`
                                            }
                                        ]}
                                        ref={ref => {
                                            imageViewerModal = ref;
                                        }}
                                    />
                                )}
                            </>
                        )}
                    </View>
                    {this.props.showLicenceAndDeleteIcons ? (
                        <ButtonView
                            style={styles.removeImageWrapper}
                            onPress={this.onImageRemove(
                                parentArrayIndex,
                                title,
                                childArrayIndex
                            )}
                        >
                            <Image source={Images.removeImage} />
                        </ButtonView>
                    ) : null}
                </View>
            );
        }
    };
}

export default DocumentImages;

const styles = StyleSheet.create({
    topContainer: {
        paddingHorizontal: 20,
        paddingTop: 40,
        paddingBottom: 70
    },
    footerStyle: {
        backgroundColor: colors.ActiveTabTitle,
        width: "100%",
        position: "absolute",
        bottom: 0,
        borderRadius: 0
    },
    textLabel: {
        ...UIFont.font(fonts.semiBold, fontSize.medium, colors.BlackColor),
        alignSelf: "flex-start",
        lineHeight: 21,
        letterSpacing: 0
    },
    datePickerStyle: {
        borderBottomWidth: 1,
        borderColor: Colors.textfieldBorder,
        width: Platform.OS ? 370 : 395
    },
    dateInput: {
        borderWidth: 0,
        justifyContent: "flex-start",
        alignItems: "flex-start",
        paddingTop: 6,
        paddingLeft: 10
    },
    dateText: {
        color: "#241332"
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start"
    },
    otherDocument: {
        ...UIFont.font(fonts.regular, fontSize.xSmall, colors.BlackColor),
        lineHeight: 16,
        letterSpacing: 0,
        textAlign: "left"
    },
    container: {
        backgroundColor: Colors.background.primary,
        alignSelf: "flex-start",
        paddingTop: Metrics.baseMargin
    },
    rowContainer: {
        flexDirection: "row",
        flexWrap: "wrap"
    },
    leftAlign: {
        position: "absolute",
        left: Metrics.ratio(6),
        top: Metrics.ratio(4)
    },
    rightAlign: {
        position: "absolute",
        right: Metrics.ratio(6),
        top: Metrics.ratio(4)
    },
    containerImages: {
        flexDirection: "row",
        flexWrap: "wrap"
    },
    imageAlignmentWrapper: {
        marginBottom: Metrics.baseMargin,
        marginLeft: Metrics.smallMargin,
        width: Metrics.halfScreenWidth - Metrics.xDoubleBaseMargin,
        height: 100,
        padding: Metrics.smallMargin
    },
    imageAdderContainer: {
        width: "100%",
        height: "100%",
        marginTop: 10,
        ...centerAligned,
        borderRadius: Metrics.smallMargin
    },
    imageContainer: {
        width: "100%",
        height: "100%",
        marginTop: 10
    },
    pickedImage: {
        width: "100%",
        height: "100%"
    },
    removeImageWrapper: {
        ...centerAligned,
        position: "absolute",
        top: 0,
        zIndex: 2,
        right: 0
    },
    pdfContainer: {
        backgroundColor: "#ECEFF1",
        width: "100%",
        height: "100%",
        ...centerAligned
    },
    icFile: {
        width: Metrics.ratio(25),
        height: Metrics.ratio(25),
        resizeMode: "contain"
    },
    txtPDF: {
        ...UIFont.font(
            fonts.regular,
            Metrics.generatedFontSize(20),
            colors.txtCol.tertiary
        )
    },
    txtPDFName: UIFont.font(
        fonts.regular,
        Metrics.generatedFontSize(14),
        colors.txtCol.tertiary
    ),
    pdfSeparator: {
        height: Metrics.ratio(15),
        width: 1,
        backgroundColor: "white",
        marginLeft: Metrics.ratio(6),
        marginRight: Metrics.ratio(8)
    },
    rowCon: {
        flexDirection: "row",
        alignItems: "center"
    },
    passwordContainer: {
        flexDirection: 'row',
        borderBottomWidth: 1,
        borderColor: Colors.textfieldBorder,
        paddingBottom: 10,
    },
    inputStyle: {
        flex: 1,
        color: colors.BlackColor,
    },
    viewstyle: {
        flex: 1,
        width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",

    },
    ImageStyle: {
        padding: 10,
        margin: 5,
        height: 30,
        width: 30,
        resizeMode: 'stretch',
        alignItems: 'center',
    },
});
