import React, { Component } from "react";
import { FlatList, View, Text } from "react-native";
import PropTypes from "prop-types";
import ListEmpty from "./ListEmpty";
import ListFooter from "./ListFooter";
import Loader from "../Loader";

class FlatListHandler extends Component {
  static propTypes = {
    data: PropTypes.array,
    isFetching: PropTypes.bool,
    isrefresh: PropTypes.bool,
    loader: PropTypes.object,
    fetchRequest: PropTypes.func
  };
  static defaultProps = { data: [], isFetching: false,isrefresh: false };

  keyExtractor = (item, index) => `item_${index}`;

  onEndReached = () => {
    this.props.fetchRequest &&
      this.props.data.length % 10 === 0 &&
      this.props.fetchRequest(true, this.props.data.length / 10 + 1);

    //this.props.fetchRequest && this.props.fetchRequest(true, this.props.data.length / 10 + 1);


  };

  onRefresh = () =>
  {

    this.props.isrefresh && this.props.fetchRequest(false, 1);

    // this.props.isrefresh &&
  }

  renderItem = ({ index }) => (
    <View>
      <Text>{`item ${index}`}</Text>
    </View>
  );

  renderListEmpty = () => {

    // (!this.props.data.length ? <ListEmpty /> : null);
    return  !this.props.data.length ? (
      <ListEmpty />
    ) : null;
  }

  renderListFooter = () => {

    return  this.props.isFetching ? (
      <ListFooter />
    ) : null;

   // return null;
  };

  render() {
    if (this.props.isFetching && !this.props.data.length) {

      return this.props.loader ? this.props.loader : <Loader />;
    }
       /* Rendering contains all the basic stuff list needs to render it self what ever extra props is passed to is overridden */
    return (
      
      <FlatList
        data={this.props.data}
        //  ListHeaderComponent={this.props.ListHeaderComponent}
        renderItem={this.renderItem}
        refreshing={this.props.isrefresh}
        onRefresh={this.onRefresh}
        onEndReached={this.onEndReached}
        keyExtractor={this.keyExtractor}
        // legacyImplementation={false}
        // pagingEnabled={true}
        onEndReachedThreshold={0.5}
        ListEmptyComponent={this.renderListEmpty}
        ListFooterComponent={this.renderListFooter}
        contentContainerStyle={
          this.props.data.length ? {} : styles.contentContainerStyle
        }
        {...this.props}
      />
    );
  }
}

const styles = {
  contentContainerStyle: {
    alignItems: "center",
    justifyContent: "center",
    height: "100%",
    width: "100%",
    paddingBottom: 100
  }
};

export default FlatListHandler;
