//FooterDetail;
import React, { Component } from "react";
import { View, StyleSheet, Text, Image, TouchableOpacity } from "react-native";
import { colors, icons, Images } from "../../assets";

const FooterDetail = ({
  style,
  text,
  backgroundColor,
  textColor,
  clickBtn,
  img
}) => {
  return (
    <TouchableOpacity
      onPress={clickBtn}
      style={[styles.footerStyle, style, backgroundColor]}
    >
      <Text style={[styles.textStyle, textColor]}>{text}</Text>
      {img && (
        <Image
          style={{ margin: 10, paddingLeft: 15 }}
          resizeMode="contain"
          source={img}
        />
      )}
    </TouchableOpacity>
  );
};

const styles = StyleSheet.create({
  footerStyle: {
    width: "100%",
    height: 50,
    justifyContent: "center",
    alignItems: "center",
    flexDirection: "row"
  },
  textStyle: {
    fontFamily: "Gibson",
    fontSize: 15,
    fontWeight: "600",
    fontStyle: "normal",
    lineHeight: 17,
    letterSpacing: 0,
    textAlign: "center"
  }
});

export default FooterDetail;
