// import React from "react";
// import { StyleSheet, View, ScrollView } from "react-native";
// import { colors, Images } from "../../assets";
// import ScrollableTabView, { DefaultTabBar } from "react-native-scrollable-tab-view";

// const HeaderTabs = ({ initialPage, children }) => {
  
 
//   return (


//     <ScrollableTabView
//       style={{ flex: 1 }}
//       initialPage={initialPage}
//       page={null}
//      //initialPage={1}
//       locked={false}
//       tabBarTextStyle={styles.tabTextStyle}
//       tabBarUnderlineStyle={styles.tabUnderline}
//       tabBarActiveTextColor={colors.ActiveTabTitle}
//       tabBarInactiveTextColor={colors.InActiveTabTitle}
//       tabBarBackgroundColor={colors.TabBackgroundColor}
//     >
//       {React.Children.map(children, (child, index) => {
//         if (!child) {
//           return;
//         }
//         return child;
//       })}
//       {/* {tab1}
//             {tab2} */}
//       {/* {tabs.map((elem, index) => {
//                 return (
//                     <View key={index} tabLabel={elem} style={styles.cardWrapper}>
//                         <FlatList
//                             data={[{ img: Images.cardImage, cardTitle: 'Nursing (RN)', hospitalName: 'Emergency Hospital', cardText: 'Lorem Ipsum is simply dum…', postDate: 'July 12, 2019', postTime: '6:00 PM to 11:00 PM', location: 'Downtown Ludington' }]}
//                             renderItem={({ item }) => <MainCard item={item} />}
//                         />


//                     </View>
//                 )
//             })} */}
//     </ScrollableTabView>
//   );
// };

// const styles = StyleSheet.create({
//   tabTextStyle: {
//     fontFamily: "Gibson",
//     fontSize: 13,
//     fontWeight: "600",
//     fontStyle: "normal",
//     lineHeight: 15,
//     letterSpacing: 0
//   },
//   tabUnderline: {
//     backgroundColor: colors.ActiveTabTitle
//   },
//   cardWrapper: {
//     backgroundColor: colors.TabsWrapper
//   }
// });

// export default HeaderTabs;

import React, { useState } from "react";
import { View, Text, StyleSheet, Dimensions } from "react-native";
import { TabView, SceneMap, TabBar } from "react-native-tab-view";
import { colors } from "../../assets";

const initialLayout = { width: Dimensions.get("window").width };

const HeaderTabs = ({ initialPage = 0, children }) => {
  // Convert passed children into tab routes
  const validChildren = React.Children.toArray(children).filter(Boolean);
  const [index, setIndex] = useState(initialPage);
  const [routes] = useState(
    validChildren.map((child, idx) => ({
      key: `tab_${idx}`,
      title: child.props.tabLabel || `Tab ${idx + 1}`,
    }))
  );

  // Dynamically map children to scenes
  const renderScene = SceneMap(
    Object.fromEntries(
      validChildren.map((child, idx) => [
        `tab_${idx}`,
        () => <View style={{ flex: 1 }}>{child}</View>,
      ])
    )
  );

  return (
    <TabView
      navigationState={{ index, routes }}
      renderScene={renderScene}
      onIndexChange={setIndex}
      initialLayout={initialLayout}
      renderTabBar={(props) => (
        <TabBar
          {...props}
          style={styles.tabBar}
          indicatorStyle={styles.tabUnderline}
          activeColor={colors.ActiveTabTitle}
          inactiveColor={colors.InActiveTabTitle}
          labelStyle={styles.tabTextStyle}
          scrollEnabled
        />
      )}
    />
  );
};

export default HeaderTabs;

const styles = StyleSheet.create({
  tabTextStyle: {
    fontFamily: "Gibson",
    fontSize: 13,
    fontWeight: "600",
    textTransform: "none",
  },
  tabUnderline: {
    backgroundColor: colors.ActiveTabTitle,
    height: 2,
  },
  tabBar: {
    backgroundColor: colors.TabBackgroundColor,
  },
});

