import React from "react";
import PropTypes from "prop-types";
import { View, Image } from "react-native";

import styles from "./styles";
import { ButtonView, Text } from "../";
import Metrics from "../../services/Metrics";

export default class ImageButton extends React.PureComponent {
    static propTypes = {
        style: PropTypes.object,
        onPress: PropTypes.oneOfType([PropTypes.func, PropTypes.array]),
        source: PropTypes.oneOfType([PropTypes.number, PropTypes.array])
            .isRequired
    };

    static defaultProps = {
        style: {},
        onPress: () => {}
    };

    render() {
        const { source, onPress, style, imgStyle, ...rest } = this.props;
        if (!Array.isArray(source)) {
            return (
                <ButtonView
                    {...rest}
                    style={[
                        {
                            padding: Metrics.smallMargin
                        },
                        style
                    ]}
                    onPress={Array.isArray(onPress) ? onPress[0] : onPress}
                >
                    <Image source={source} resizeMode="contain" />
                </ButtonView>
            );
        }

        return (
            <View style={styles.container}>
                {source.map((item, index) => (
                    <ButtonView
                        {...rest}
                        style={[
                            style,
                            {
                                paddingVertical: Metrics.baseMargin
                            }
                        ]}
                        key={`button_${index}`} // eslint-disable-line react/no-array-index-key
                        onPress={
                            Array.isArray(onPress)
                                ? onPress[index] || (() => {})
                                : onPress
                        }
                    >
                        <Image source={source[index]} resizeMode="contain" />
                    </ButtonView>
                ))}
            </View>
        );
    }
}
