import React, { forwardRef, useImperativeHandle, useState } from "react";
import { Modal, Image } from "react-native";
import PropTypes from "prop-types";

import ImageViewer from "react-native-image-zoom-viewer";
import { icons } from "../../assets";
import { ButtonView } from "../";

const images = [
    {
        url:
            "https://360cubes.com/medical_shift_staging/public/uploads/user/48593cf4bc6499ef2845c47773bcb6e5."
    },
    {
        url:
            "https://360cubes.com/medical_shift_staging/public/uploads/user/8d1ecd90e69465d9f5d6f28bbdedd24a."
    },
    {
        url:
            "https://360cubes.com/medical_shift_staging/public/uploads/user/f8c13a95c10e89bed3f5445a220d32fc.jpg"
    }
];

const ImageViewerModal = forwardRef((props, ref) => {
    const [isVisible, setVisible] = useState(false);

    ImageViewerModal.propTypes = {
        cardStyle: PropTypes.object
    };
    ImageViewerModal.defaultProps = {
        cardStyle: {}
    };

    hide = () => {
        setVisible(false);
    };
    useImperativeHandle(ref, () => ({
        show() {
            setVisible(true);
        },

        hideModal() {
            setVisible(false);
        }
    }));

    return (
        <Modal transparent={true} visible={isVisible} animationIn="fadeIn">
            <ImageViewer
                imageUrls={props.images || images}
                enableSwipeDown
                onCancel={() => {
                    this.hide();
                }}
                footerContainerStyle={{
                    flex: 1,
                    alignSelf: "center"
                }}
                enableImageZoom
                renderHeader={() => (
                    <ButtonView
                        style={{
                            position: "absolute",
                            left: 20,
                            top: 50,
                            zIndex: 1,
                            backgroundColor: "white",
                            padding: 5,
                            borderRadius: 2
                        }}
                        onPress={hide}
                    >
                        <Image
                            source={icons.ic_cross}
                            style={{ width: 20, height: 20 }}
                        />
                    </ButtonView>
                )}
                renderFooter={props.renderFooter}
            />
        </Modal>
    );
});

export default ImageViewerModal;
