import React, { Component } from "react";
import { StyleSheet, View, Image, Text } from "react-native";
import { colors, UIFont, fonts } from "../../assets";
import { Metrics } from "../../theme";
import { IMAGE_BASE_URL } from "../../services/WebService";
import { TouchableOpacity } from "react-native-gesture-handler";
import InfoRoundBox from "../InfoRoundBox";
import Utils from "../../Utils";

class InfoCard extends Component {
    _getRate = (value) => {

        const { item } = this.props;
        const { contract_invitations, contract_type, total_hours } = item;

        const { bid_amount } = contract_invitations;

        let rate = 0;
        if (contract_type === 'Contract') {
            rate = !Utils.isNull(bid_amount) && bid_amount !== '0.00' ? parseFloat(bid_amount)  : parseFloat(value);
        } else {
            rate = !Utils.isNull(bid_amount) && bid_amount !== '0.00' ? parseFloat(bid_amount) / total_hours : parseFloat(value);
        }
        return rate;
    }
    render() {
        const { style, item, rightText, onPress, onRightTextPress } = this.props;
        const { full_name, category_name, rating, professional_title, image_url,
            hourly_pay_rate, contract_rate, contract_type,hour_rate } = item;
        let img = image_url == "" ? "image/default_user.png" : image_url;
        return (
            <View style={[{
                flexDirection: 'row',
                alignItems: 'center',
                justifyContent: 'space-between',
                flex: 1,
                backgroundColor: colors.WhiteColor,
                padding: 12
            }, style]}>
                <TouchableOpacity onPress={onPress} disabled={onPress ? false : true}>
                    <View style={styles.container}>
                        <Image source={{ uri: `${IMAGE_BASE_URL}/${img}` }} style={styles.img} />
                        <View style={{ marginLeft: 16 }}>
                            <Text style={styles.titleStyle}>{full_name}</Text>
                            <Text style={styles.categoryStyle}>{category_name}</Text>
                            <Text style={styles.subCategoryStyle}>{professional_title}</Text>

                        </View>
                    </View>
                </TouchableOpacity>
                {
                    rightText && <TouchableOpacity
                        onPress={onRightTextPress}>
                        <Text style={[styles.titleStyle, { color: colors.ActiveTabTitle, fontSize: 14 }]}
                        >{'View Summary'}</Text>
                    </TouchableOpacity>
                }
                {
                    contract_type === 'Contract' && <InfoRoundBox
                        heading={'Hour Rate'}
                        subHeading={`$${this._getRate(contract_rate)}`}
                        style={{ width: 80 }}
                    />
                }
                {
                    hourly_pay_rate && <InfoRoundBox
                        heading={'Hour Rate'}
                       // subHeading={`$${this._getRate(hourly_pay_rate)}`}
                        subHeading={`$${hour_rate}`}
                        style={{ width: 80 }}
                    />
                }


            </View>
        );
    }
}
const styles = StyleSheet.create({
    container: {
        flexDirection: 'row',
    }, img: {
        width: 60,
        height: 60,
        borderRadius: 30,
        borderColor: colors.WhiteColor,
        borderWidth: 2,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        padding: 5,
        alignSelf: "flex-end"
    }, titleStyle: {
        ...UIFont.font(fonts.semiBold, 20, colors.BlackColor),
    },
    categoryStyle: {
        ...UIFont.font(fonts.regular, 14, colors.BlackColor)
    },
    subCategoryStyle: {
        ...UIFont.font(fonts.regular, 10, colors.BlackColor),
    },
});

export default InfoCard;