import React, { Component } from "react";
import { StyleSheet, View, Text } from "react-native";
import { colors } from "../../assets";
import { Metrics } from "../../theme";
import { TouchableOpacity } from "react-native-gesture-handler";

class InfoRoundBox extends Component {

    render() {
        const { style, onPress, heading, subHeading, headingStyle, subHeadingStyle } = this.props;
        return (
            <TouchableOpacity onPress={onPress} disabled={onPress ? false : true}>
                <View style={[styles.container, style]}>
                    <Text style={[styles.headingS, headingStyle]}>{heading}</Text>
                    <Text style={[styles.subHeadingS, subHeadingStyle]}>{subHeading}</Text>
                </View>
            </TouchableOpacity>
        );
    }
}
const styles = StyleSheet.create({
    container: {
        flex: 1,
        margin: 4,
        padding: 4,
        height: 45,
        borderRadius: 5,
        borderWidth: 1,
        justifyContent: "center",
        alignItems: "center",
        borderColor: '#dde3f6'
    }, headingS: {
        fontSize: 9,
        textAlign:'center'
    }, subHeadingS: {
        fontWeight: 'bold',
        fontSize: 12,
        color: colors.BlackColor
    }
});

export default InfoRoundBox;