import React from "react";
import { View, Text } from "react-native";
import ProfileImage from "../ProfileImage";
import AppStyles from "../../services/AppStyles";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";
import { ButtonView } from "../../components";

const LappingProfile = ({ requests = [], onRequests }) => {
  if (requests.length <= 5) {
    return requests.map((user, index) => (
      <View style={styles.container} key={user}>
        <ButtonView
          onPress={onRequests}
          style={[
            styles.profileWrapper,
            {
              marginLeft: index * Metrics.ratio(20)
            }
          ]}
        >
          <ProfileImage radius={30} img={user} zIndex={index} />
        </ButtonView>
      </View>
    ));
  } else {
    const twoRequests = [];
    twoRequests.push(requests[0]);
    twoRequests.push(requests[1]);
    twoRequests.push(requests[2]);
    twoRequests.push(requests[3]);
    twoRequests.push(requests[4]);
    twoRequests.push(requests[5]);
    return (
      <View style={styles.container}>
        {twoRequests.map((user, index) => (
          <ButtonView
            onPress={onRequests}
            key={user}
            style={[
              styles.profileWrapper,
              {
                marginLeft: index * Metrics.ratio(20)
              }
            ]}
          >
            {index === 5 ? (
              <View style={styles.containerRequestsCount}>
                <Text style={styles.txtCount}>{`+${requests.length - 2}`}</Text>
              </View>
            ) : (
              <ProfileImage radius={30} img={user} zIndex={index} />
            )}
          </ButtonView>
        ))}
      </View>
    );
  }
};

const styles = {
  container: {
    flexDirection: "row",
    alignItems: "center",
    marginBottom: Metrics.ratio(2)
  },
  profileWrapper: {
    ...AppStyles.centerAligned,
    ...AppStyles.roundImage(35),
    position: "absolute",
    backgroundColor: Colors.background.secondary
  },
  containerRequestsCount: {
    ...AppStyles.centerAligned,
    ...AppStyles.roundImage(36),
    backgroundColor: Colors.text.octonary,
    borderColor: Colors.background.secondary,
    borderWidth: 2
  },
  txtCount: {}
};

export default LappingProfile;
