import React, { Component } from "react";
import {
    View,
    TouchableOpacity,
    Text,
    Image,
    TouchableWithoutFeedback,
} from "react-native";
import { colors, icons, Images } from "../../assets";
import CardBottom from "../CardBottom";
import CardStatus from "../CardStatus";
import styles from "./styles";
import { push, getNavigatorRef } from "../../services/NavigationService";
import { IMAGE_BASE_URL } from "../../services/WebService";
import { Metrics } from "../../services";
import { getCurrentRouteName } from "../../services/NavigationService";
import Utils from "../../Utils";

CardTitle = (
    {
        id,
        category_name: cardTitle = "",
        full_name: hospitalName = "",
        description: cardText = "",
        showIcon = true,
        since: time = "2 min ago",
        contract_status,
        is_onboarded,
        since_onboarded_date
    },
    onDelete,
    routeName
) => {
    return (
        <View style={styles.containerTitle}>
            <View>
                <View
                    style={{
                        flexDirection: "row",
                        justifyContent: "space-between"
                    }}
                >
                    <Text
                        style={styles.cardTitleText}
                        numberOfLines={1}
                        ellipsizeMode="tail"
                    >
                        {cardTitle.length < 14
                            ? cardTitle
                            : cardTitle.slice(0, 14) + "..."}
                    </Text>
                    <View style={styles.cardTitleRight}>
                        {!routeName &&
                            contract_status == "active" &&
                            is_onboarded == 0 && (
                                <TouchableOpacity onPress={onDelete}>
                                    <Image source={Images.Trash} />
                                </TouchableOpacity>
                            )}
                        <Text
                            style={[styles.cardText, { alignSelf: "flex-end" }]}>

                            {is_onboarded == 1 ? since_onboarded_date : time}

                        </Text>
                    </View>
                </View>
                <Text style={styles.cardTitleText2}>{hospitalName}</Text>
                
                <Text numberOfLines={1} style={styles.cardText}>
                    {cardText}
                </Text>

            </View>
        </View>
    );
};

CardDateTime = (item) => {
    const {
        is_onboarded_contract_history,
        onboarded_contract_history } = item;

    const { shift_start_date, shift_end_date, shift_start_time, shift_end_time } = item;

    let end_date = shift_end_date;
    let start_date = shift_start_date;
    let start_time = shift_start_time;
    let end_time = shift_end_time;

    if (is_onboarded_contract_history) {
        const { contract_type } = onboarded_contract_history;
        if (contract_type === 'Shift') {
            start_time = onboarded_contract_history.shift_start_time
            end_time = onboarded_contract_history.shift_end_time
        }
    }
    return (
        <View style={styles.containerDate}>
            <Text
                style={styles.cardDate}
            >{`${start_date} to ${end_date}`}</Text>
            <Text
                style={styles.cardTime}
            >{`${start_time} to ${end_time}`}</Text>
        </View>
    );
};

CardStatusFunc = (
    label = "Active",
    buttonColor = "rgb(65,218,138)",
    boo,
    pending
) => {
    return (
        <View style={{ flexDirection: "row" }}>
            <View style={{ paddingTop: boo ? 15 : 0 }}>
                {!pending ? (
                    <CardStatus
                        label={label}
                        style={{
                            backgroundColor: buttonColor,
                            paddingHorizontal: Metrics.doubleBaseMargin,
                            marginBottom: Metrics.smallMargin / 2
                        }}
                    />
                ) : (
                        <Text
                            style={
                                pending == "Rejected"
                                    ? styles.rejectedText
                                    : styles.pendingText
                            }
                        >
                            {pending}
                        </Text>
                    )}
            </View>
            {/*boo && (
        <Image
          style={{ position: "absolute", right: 0, alignSelf: "flex-end" }}
          source={icons.ic_trending_flat}
        />
      )*/}
        </View>
    );
};

CardFooter = ({ location_address: location = "Illinois 60523, USA" }) => {
    return (
        <View style={styles.containerLocation}>
            <Image source={Images.placesBlack} />
            <Text numberOfLines={1} style={styles.cardLocationText}>
                {location}
            </Text>
            <Image source={icons.ic_trending_flat} />
        </View>
    );
};

function RateLabel(rate) {
    return (
        <View style={styles.rateView}>
            <Image source={Images.img_star} />
            <Text style={styles.rateStyle}>{rate}</Text>
        </View>
    );
}

const CardImage = ({ rating, image_url }) => {
    let showIcon = Utils.getUserType() == "Contractor" ? true : false;
    return (
        <View
            style={{
                width: Metrics.screenWidth / 2.5,
                height: Metrics.screenWidth / 2.6,
                borderRadius: 5
            }}
        >
            <Image
                // source={Images.dummyImages[Math.round(Math.random() * 2)]}
                source={{
                    uri: `${IMAGE_BASE_URL}${image_url}`
                }}
                style={styles.imgStyle}
            />
            {/*showIcon && RateLabel(rating)*/}
        </View>
    );
};

const CardTop = (item, onDelete, isClosedItem, routeName, pending) => {
    let boo = getCurrentRouteName() === "onboardProjects" || "contractorInvitation";
    return (
        <View style={styles.upperRow}>
            {CardImage(item)}
            <View style={styles.besideImg}>
                {CardTitle(item, onDelete, routeName)}
                {CardDateTime(item)}
                {CardStatusFunc(
                    item.is_onboarded && item.contract_status === "active"
                    ?item.is_marked === 1 ? "PENDING APPROVAL":"ONBOARD"
                        : isClosedItem
                            ? "Closed"
                            : "Active",
                    item.is_onboarded && item.contract_status === "active"
                        ? "#fcb801"
                        : isClosedItem
                            ? colors.LightGreyColor
                            : colors.btnActive,
                    boo,
                    pending
                )}
                {!boo && CardFooter(item)}
            </View>
        </View>
    );
};

onCardDetail = (item, isClosed) => ev =>
    push("detailScreen", { data: item, isClosed });

const MainCard = ({
    item,
    onDelete,
    isClosedItem = false,
    goTo,
    routeName,
    pending = false
}) => {
    return (
       
            <View style={styles.container}>
                 <TouchableWithoutFeedback onPress={() => goTo(item, isClosedItem)}>
                    <View>
                    {CardTop(item, onDelete, isClosedItem, routeName, pending)}
                <CardBottom data={item} />
                    </View>
                
                </TouchableWithoutFeedback>
            </View>
       // 
    );
};

export default MainCard;
