import { StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import { Metrics } from "../../services";

export default StyleSheet.create({
    container: {
        margin: 10,
        backgroundColor: colors.cardColor,
        flexDirection: "column",
        padding: 12,
        borderRadius: 8
    },
    upperRow: {
        flexDirection: "row",
        marginBottom: 10
    },
    imgStyle: {
        height: Metrics.screenWidth / 2.6,
        width: Metrics.screenWidth / 2.5,
        borderRadius: 5
    },
    besideImg: {
        flex: 1,
        backgroundColor: colors.cardColor,
        paddingLeft: 10
    },
    containerTitle: { paddingTop: Metrics.smallMargin / 2.5 },
    cardTitleText: {
        paddingRight: 2,
        textAlign: "left",
        ...UIFont.font(fonts.semiBold, fontSize.small, colors.CardDate),
        lineHeight: 17,
        letterSpacing: 0
    },
    cardTitleText2: {
        ...UIFont.font(fonts.regular, 10, colors.ActiveTabTitle),
        lineHeight: 12,
        letterSpacing: 0
    },
    cardText: {
        ...UIFont.font(fonts.regular, 9, "#9697ab"),
        lineHeight: 11,
        letterSpacing: 0,
        marginTop: 5
    },
    cardDate: {
        ...UIFont.font(fonts.semiBold, 10, colors.CardDate),
        lineHeight: 12,
        letterSpacing: 0
    },
    cardTime: {
        ...UIFont.font(fonts.regular, 10, colors.CardDate),
        lineHeight: 12,
        letterSpacing: 0
    },
    cardLocationText: {
        flex: 1,
        ...UIFont.font(fonts.regular, 9, colors.CardDate),
        paddingLeft: 5,
        lineHeight: 11,
        letterSpacing: 0
    },
    cardTitleRight: {
        justifyContent: "space-between",
        alignItems: "center"
    },
    rateStyle: {
        ...UIFont.font(fonts.regular, 10, colors.cardColor)
    },
    rateView: {
        width: 30,
        height: 15,
        backgroundColor: "#8F2322",
        position: "absolute",
        top: 0,
        right: 0,
        borderRadius: 2,
        justifyContent: "center",
        alignItems: "center",
        flexDirection: "row"
    },
    containerLocation: { flex: 1, flexDirection: "row" },
    containerDate: {
        marginTop: Metrics.smallMargin,
        paddingVertical: Metrics.smallMargin / 2
    },
    pendingText: {
        ...UIFont.font(fonts.regular, 14, "#41da8a")
    },
    rejectedText: {
        ...UIFont.font(fonts.regular, 14, "red")
    }
});
