import React, { Component } from "react";
import { View, StyleSheet, Text, Image, TouchableOpacity } from "react-native";
import { colors, UIFont, fonts, fontSize, icons } from "../../assets";
import Colors from "../../services/Colors";

const MileagePaidBidRate = ({
    style = {},
    text,
    textColor,
    val1,
    val2,
    onPress
}) => {
    return (
        <View style={styles.locationPart}>
            <View style={styles.navStyle}>
                <Image source={icons.ic_nav} style={styles.navIcon} />
            </View>
            <View style={{ flex: 3 }}>
                <View
                    style={
                        Object.keys(style).length > 0
                            ? styles.simpleStyle
                            : styles.addressStyle
                    }
                >
                    <Text numberOfLines={2} style={[styles.textStyle, style]}>
                        {val1}
                    </Text>
                </View>
                <View style={styles.simpleStyle}>
                    <TouchableOpacity onPress={onPress}>
                        <Text
                            numberOfLines={2}
                            style={[styles.textStyle, style]}
                        >
                            {val2 && val2.length > 0 ? val2 : "Your Location"}
                        </Text>
                    </TouchableOpacity>
                </View>
            </View>
            <View style={{ flex: 1.5 }}>
                <View
                    style={
                        Object.keys(style).length > 0
                            ? styles.simpleStyle
                            : [
                                  styles.addressStyle,
                                  {
                                      marginRight: 20
                                  }
                              ]
                    }
                />
                <View style={{ flex: 1, justifyContent: "center" }} />
            </View>
        </View>
    );
};

const styles = StyleSheet.create({
    locationPart: {
        marginTop: 5,
        flexDirection: "row",
        height: 150
    },
    textStyle: {
        ...UIFont.font(fonts.reqular, 15, Colors.textfieldBorder),
        lineHeight: 15
    },
    navStyle: {
        flex: 1,
        zIndex: 999,
        justifyContent: "center",
        alignItems: "center"
    },
    navIcon: { width: 12, height: 83, zIndex: 999 },
    addressStyle: {
        flex: 1,
        justifyContent: "center",
        borderBottomWidth: 2,
        borderBottomColor: Colors.textfieldBorder
    },
    simpleStyle: {
        flex: 1,
        justifyContent: "center"
    }
});

export default MileagePaidBidRate;
