import React, { PureComponent } from "react";
import { Modal } from "react-native";

export default class ReusableModal extends PureComponent {
  state = { modalVisible: false };

  setModalVisible(modalVisible) {
    this.setState({ modalVisible });
  }

  render() {
    const { children } = this.props;
    const { modalVisible } = this.state;
    return (
      <Modal
        animationType="slide"
        transparent={true}
        visible={modalVisible}
        onRequestClose={() => {
          this.setModalVisible(false)
        }}
      >
        {children}
      </Modal>
    );
  }
}
