import React, { PureComponent } from "react";
import { View, Modal, Image, Text } from "react-native";
import { AppStyles, Images, Metrics, Colors } from "../../services";
import { icons } from "../../assets";

export default class NetInfoModal extends PureComponent {
  render() {
    const { isNetworkConnected } = this.props

    if (isNetworkConnected) return null;

    return (<Modal transparent>
      <View style={{ flex: 1, ...AppStyles.centerAligned, backgroundColor: "rgba(0,0,0,0.2)" }} >
        <View style={{
          backgroundColor: "white",
          paddingVertical: Metrics.ratio(50),
          paddingHorizontal: Metrics.baseMargin,
          borderRadius: Metrics.baseMargin,
          ...AppStyles.centerAligned, marginHorizontal: Metrics.doubleBaseMargin
        }}>
          <Image source={icons.noNetwork} style={{ width: Metrics.ratio(80), height: Metrics.ratio(80), resizeMode: "contain" }} />
          <Text style={styles.txtNoNetwork}>Network not found check your internet connection</Text>
        </View>
      </View>
    </Modal>);
  }
}

const styles = { txtNoNetwork: { fontSize: 14, paddingTop: Metrics.doubleBaseMargin, textAlign: "center" } }