import React, { Component } from "react";
import { connect } from "react-redux";
import { View, Image, StyleSheet, Text, Platform } from "react-native";
import { colors, UIFont, fonts } from "../../assets";
import { IMAGE_BASE_URL } from "../../services/WebService";

class NotificationBar extends Component {
    CardImage = ({ image_url }) => {
        return (
            <View style={styles.cardImage}>
                <View elevation={15}>
                    <Image
                        source={{
                            uri: `${IMAGE_BASE_URL}${image_url}`
                        }}
                        resizeMode="cover"
                        style={styles.imgStyle}
                    />
                </View>
            </View>
        );
    };

    render() {
        const { showBar, data } = this.props.notificationBar;
        if (showBar) {
            return (
                <View style={styles.container}>
                    {this.CardImage(data)}
                    <View style={styles.detailCard}>
                        <Text style={styles.nameStyle}>{data.full_name}</Text>
                        <Text style={styles.messageStyle}>{data.message}</Text>
                    </View>
                </View>
            );
        } else {
            return null;
        }
    }
}

const actions = {};
const mapStateToProps = ({ notificationBar }) => ({ notificationBar });

export default connect(mapStateToProps, actions)(NotificationBar);

const styles = StyleSheet.create({
    container: {
        top: Platform.OS ? 50 : 5,
        position: "absolute",
        width: "96%",
        height: 80,
        borderRadius: 7,
        backgroundColor: "#ffffff",
        alignSelf: "center",
        borderLeftWidth: 5,
        borderLeftColor: colors.ActiveTabTitle,
        flexDirection: "row"
    },
    imgStyle: {
        width: 50,
        height: 50,
        borderRadius: 25,
        borderColor: colors.WhiteColor,
        borderWidth: 2,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        alignSelf: "flex-end"
    },
    cardImage: {
        flex: 1,
        paddingHorizontal: 10,
        justifyContent: "center"
    },
    detailCard: {
        flex: 5,
        justifyContent: "center"
    },
    nameStyle: {
        ...UIFont.font(fonts.semiBold, 14, colors.BlackColor)
    },
    messageStyle: {
        ...UIFont.font(fonts.regular, 10, colors.BlackColor)
    }
});
