import React from "react";
import _ from "lodash";
import { View, Image as ImageRN } from "react-native";
import Image from "../Image";
import AppStyles from "../../services/AppStyles";
import { Images, icons } from "../../assets";

const ProfileImage = ({ radius = 50, img = undefined, style = {} }) => {
  return !_.isEmpty(img) &&
    img !== "http://360cubes.com/ybuyit_staging/public/male.png" ? (
      <View style={AppStyles.roundImage(radius)}>
        <Image
          source={{
            uri: img
          }}
          style={[AppStyles.roundImage(radius, "cover"), style]}
          borderRadius={radius / 2}
          placeholderSource={icons.accountCircle}
          placeholderStyle={AppStyles.roundImage(radius)}
        />
      </View>
    ) : (
      <View style={AppStyles.roundImage(radius)}>
        <ImageRN
          source={icons.accountCircle}
          style={{ width: radius, height: radius }}
        />
      </View>
    );
};

export default ProfileImage;
