import React from "react";
import _ from "lodash";
import { View, Text, Image as ImageRN, StyleSheet } from "react-native";
import Image from "../Image";
import AppStyles from "../../services/AppStyles";
import { Images, icons, UIFont, fontSize, fonts, colors } from "../../assets";
import StarRating from "react-native-star-rating";

const Rate = ({ label, eachRating, cbSelectedStar }) => {
    return (
        <View
            style={{
                width: "100%",
                flexDirection: "row",
                justifyContent: "space-between",
                paddingHorizontal: 20,
                paddingVertical: 25
            }}
        >
            <Text style={styles.labelStyle}>{label}</Text>
            <StarRating
                disabled={false}
                maxStars={5}
                rating={eachRating}
                starSize={20}
                fullStarColor={"rgb(255,186,73)"}
                selectedStar={cbSelectedStar}
            />
        </View>
    );
};

const styles = StyleSheet.create({
    labelStyle: {
        ...UIFont.font(fonts.semiBold, 16, colors.BlackColor)
    }
});

export default Rate;
