import React, { Component, Fragment } from "react";
import { View, TouchableOpacity, Text, Image } from "react-native";
import { colors, icons, Images } from "../../assets";
import { Metrics } from "../../services";
import { IMAGE_BASE_URL } from "../../services/WebService";
import { Separator } from "../../components";
import styles from "./styles";
import Utils from "../../Utils";
import { getCurrentRouteName } from "../../services/NavigationService";

const CardLabel = () => {
    return (
        <View style={styles.textCardRight}>
            <Text
                style={[
                    styles.pendingText,
                    {
                        alignSelf: "flex-end",
                        paddingHorizontal: 20
                    }
                ]}
            >
                Pending...
            </Text>
        </View>
    );
};

const CardArrow = () => {
    return (
        <View style={styles.textCardRight}>
            <Image style={styles.imageIcon} source={icons.expand_farward} />
        </View>
    );
};

const CardRight = (
    {
        bid_amount,
        hourly_rate,
        hourly_pay_rate,
        shift_end_time,
        shift_start_time,
        contract_type,
        total_hours
    },
    bidAmount
) => {
    let route =
        (getCurrentRouteName() === "requests" &&
            +bid_amount.slice(0, bid_amount.indexOf(".")) == 0) ||
        (getCurrentRouteName() !== "requests" &&
            bidAmount == undefined &&
            hourly_rate == null);
    let label =
            getCurrentRouteName() === "requests" &&
            +bid_amount.slice(0, bid_amount.indexOf(".")) == 0
                ? "Our Rate"
                : getCurrentRouteName() == "requests"
                ? "Bid Amount"
                : getCurrentRouteName() === "detailScreen" ||
                  getCurrentRouteName() === "onboardProjectsDetail"
                ? "Final Amount"
                : bidAmount
                ? "Final Amount"
                : "Hour Rate",
        amount =
            getCurrentRouteName() === "requests" &&
            bid_amount !== "0.00" &&
            contract_type == "Shift"
                ? bid_amount / total_hours
                :// Utils.calculateDiffTime({ shift_end_time, shift_start_time })
                getCurrentRouteName() === "requests" &&
                  bid_amount !== "0.00" &&
                  contract_type == "Contract"
                ? bid_amount
                : bidAmount
                ? bidAmount
                : hourly_rate;
    return (

        <View style={styles.cardRight}>
            
            {!route && (
                <View style={styles.amountStyle}>
                    <Text style={styles.textAmount}>{label}</Text>
                    <Text style={styles.textPrice}>${parseFloat(amount).toFixed(2)}</Text>
                </View>
            )}

        </View>

    );
};

RateLabel = rate => {
    return (
        <View style={styles.rateLabel}>
            <Image source={Images.img_star} />
            <Text style={styles.rateStyle}>{rate}</Text>
        </View>
    );
};

const CardCenter = (
    { full_name, category_name, rating, professional_title },
    screen
) => {
    return (
        <View style={styles.cardCenter}>
            <View style={{flexDirection: "row" }}>
                <Text
                    ellipsizeMode="tail"
                    numberOfLines={2}
                    style={styles.titleStyle}
                >
                    {full_name}
                </Text>
                {rating && RateLabel(rating)}
            </View>
            <Text style={styles.categoryStyle} numberOfLines={1}>
                {category_name}
            </Text>
            {screen === "sent" ? (
                <Text style={styles.pendingText}>Pending...</Text>
            ) : (
                <Text style={styles.subCategoryStyle}>
                    {professional_title}
                </Text>
            )}
        </View>
    );
};

const CardImage = ({ image_url }) => {
    return (
        <View style={styles.cardImage}>
            <View elevation={15}>
                <Image
                    source={{
                        uri: `${IMAGE_BASE_URL}/${image_url}`
                    }}
                    resizeMode="cover"
                    style={styles.imgStyle}
                />
            </View>
        </View>
    );
};

const RequestsCard = ({
    style,
    request,
    item,
    goTo,
    showSeperator,
    bidAmount,
    screen
}) => {
    let img = item.image_url == "" ? "image/default_user.png" : item.image_url;
    return (
        <Fragment>
            <TouchableOpacity
                onPress={() => goTo(item, request)}
                style={[styles.container, style]}
            >
                {/*CardImage(item)*/}
                <View style={styles.cardImage}>
                    <View elevation={15}>
                        <Image
                            source={{
                                uri: `${IMAGE_BASE_URL}/${img}`
                            }}
                            resizeMode="cover"
                            style={styles.imgStyle}
                        />
                    </View>
                </View>
                {CardCenter(item, screen)}
                {request == "received" && CardRight(item, bidAmount)}
                {request == "sent" && CardLabel()}
                {request == "goToProfile" && CardArrow()}
            </TouchableOpacity>
            {showSeperator && <Separator style={styles.separatorStyle} />}
        </Fragment>
    );
};

export default RequestsCard;
