import { StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import { Metrics } from "../../services";

export default StyleSheet.create({
    container: {
        width: "100%",
        height: 60,
        flexDirection: "row",
        backgroundColor: "#f8f8f8",
        marginTop: 20
    },
    cardImage: {
        flex: 1,
        paddingHorizontal: 10
    },
    cardCenter: {
        flex: 2.7
    },
    cardRight: {
        flex: 2,
        justifyContent: "center",
        alignItems: "center"
    },
    textCardRight: {
        flex: 2
    },
    separatorStyle: {
        backgroundColor: "#dde3f6",
        marginHorizontal: 10,
        marginTop: 20
    },
    rateStyle: {
        ...UIFont.font(fonts.regular, 13, colors.BlackColor),
        lineHeight: 28,
        letterSpacing: 0
    },
    titleStyle: {
        ...UIFont.font(fonts.semiBold, 18, colors.BlackColor),
       // flex: 1,
    },
    categoryStyle: {
        ...UIFont.font(fonts.regular, 14, colors.BlackColor),
    },
    subCategoryStyle: {
        ...UIFont.font(fonts.regular, 10, colors.BlackColor),
        flex: 1
    },
    amountStyle: {
        width: "80%",
        borderColor: "#dde3f6",
        borderWidth: 1,
        borderRadius: 5,
        justifyContent: "center",
        alignItems: "center",
        paddingVertical: 5
    },
    textAmount: {
        ...UIFont.font(fonts.regular, 9, "#2d3057")
    },
    textPrice: {
        ...UIFont.font(fonts.semiBold, 16, "#212346")
    },
    rateLabel: {
        width: 30,
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center"
    },
    imgStyle: {
        width: 60,
        height: 60,
        borderRadius: 30,
        borderColor: colors.WhiteColor,
        borderWidth: 2,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        padding: 5,
        alignSelf: "flex-end"
    },
    pendingText: {
        ...UIFont.font(fonts.regular, 14, "#41da8a")
    },
    acceptedText: {
        ...UIFont.font(fonts.regular, 16, "#08548c")
    },
    imageIcon: {
        marginTop: Metrics.baseMargin,
        marginRight: Metrics.baseMargin,
        alignSelf: "flex-end"
    }
});
