import _ from "lodash";
import React from "react";
import PropTypes from "prop-types";
import {
    View,
    Image,
    StyleSheet,
    TouchableOpacity,
    TextInput
} from "react-native";
import Metrics from "../../services/Metrics";
import { colors, icons } from "../../assets";
import { TextLabel, ButtonView } from "../";

const SearchBox = (props: Object) => {
    const { onPress, value, onChangeText, ...rest } = props;
    return (
        <View style={styles.header}>
            <View style={styles.inputWrapper}>
                <View style={{ flex: 1, alignItems: "flex-end" }}>
                    <Image
                        source={icons.search_icon_black}
                        style={{ height: 15, width: 15, margin: 10 }}
                    />
                </View>
                <TextInput
                    onChangeText={onChangeText}
                    placeholder={"Search"}
                    value={value}
                    style={{
                        flex: 10,
                        color: "#6e6e6e",
                        paddingHorizontal: 10,
                        paddingBottom: 5,
                        borderLeftColor: colors.bgLightGrey,
                        borderLeftWidth: 1
                    }}
                />
                <TouchableOpacity
                    style={{ flex: 1, alignItems: "flex-end" }}
                    onPress={onPress}
                >
                    <Image source={icons.filter_icon} />
                </TouchableOpacity>
            </View>
        </View>
    );
};

export default SearchBox;

const styles = StyleSheet.create({
    header: {
        height: 40,
        width: "100%",
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "#f8f8f8",
        marginTop: 10
    },
    inputWrapper: {
        flexDirection: "row",
        marginHorizontal: 12,
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        alignItems: "center",
        height: 40,
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        paddingHorizontal: 20
    }
});
