import React, { Component } from "react";
import { View, Text, StyleSheet } from "react-native";
import Slider from "react-native-slider";
import { colors, UIFont, fonts, fontSize } from "../../assets";

class SliderComponent extends Component {
    constructor(props) {
        super(props);
        this.state = {
            value: 0.2
        };
    }

    render() {
        const {
            minimumValue,
            maximumValue,
            onValueChange,
            value,
            thumbImage
        } = this.props;
        return (
            <View style={styles.container}>
                <Slider
                    value={value}
                    minimumValue={minimumValue}
                    maximumValue={maximumValue}
                    step={1}
                    thumbImage={thumbImage}
                    thumbTintColor={"#ffffff"}
                    thumbStyle={styles.thumb}
                    minimumTrackTintColor={"#08548c"}
                    maximumTrackTintColor={"#eaeaf0"}
                    style={{ width: "95%", marginHorizontal: 10 }}
                    onValueChange={onValueChange}
                />
                <View style={{ flexDirection: "row", paddingHorizontal: 10 }}>
                    <Text
                        style={[styles.textStyle, { alignSelf: "flex-start" }]}
                    >
                        {minimumValue}
                    </Text>
                    <Text
                        style={[styles.textStyle, { textAlign: "right" }]}
                    >{`${value} / ${maximumValue}`}</Text>
                </View>
            </View>
        );
    }
}

export default SliderComponent;

var styles = StyleSheet.create({
    container: {
        marginLeft: 10,
        marginRight: 10,
        alignItems: "stretch",
        justifyContent: "center"
    },
    thumb: {
        width: 30,
        height: 30,
        borderRadius: 15,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        },
        alignItems: "center",
        justifyContent: "center"
    },
    textStyle: {
        flex: 1,
        ...UIFont.font(fonts.reqular, fontSize.small, "#9e9e9e")
    }
});
