import React, { Component } from "react";
import {
    View,
    Text,
    Button,
    Image,
    StyleSheet,
    TouchableOpacity
} from "react-native";
import { connect } from "react-redux";
import { generalSaveAction } from "../../actions/GeneralActions";
import { USER } from "../../actions/ActionTypes";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";

const SquareCard = (props: Object) => {
    const { icon, text, onClick } = props;

    return (
        <View elevation={15} style={styles.inputWrapper}>
            <TouchableOpacity
                onPress={onClick}
                style={{
                    padding: Metrics.doubleBaseMargin,
                    justifyContent: "space-around",
                    alignItems: "center"
                }}
            >
                <Image
                    source={icon}
                    style={{
                        marginBottom: Metrics.doubleBaseMargin
                    }}
                />
                <Text style={styles.textStyle}>{text}</Text>
            </TouchableOpacity>
        </View>
    );
};
const styles = StyleSheet.create({
    inputWrapper: {
        width: "47.5%",
        marginTop: Metrics.doubleBaseMargin,
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.8,
        shadowRadius: 20,
        shadowOffset: {
            height: 5,
            width: 5
        }
    },
    textStyle: {
        textAlign: "center",
        ...UIFont.font(fonts.regular, 11, "#363e51")
    }
});
export default SquareCard;
