import React, { Component } from "react";
import { View, Text, Image } from "react-native";
import { WithFetching } from "../../HOC";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { connect } from "react-redux";
import { TouchableOpacity } from "react-native-gesture-handler";
import { Images, icons, UIFont, fontSize, fonts, colors } from "../../assets";
import { Container, TextLabel } from "../../components";
import { Metrics } from "../../theme";

class StripeCardDetails extends Component {
    _renderBtn = (title, onPress) => {
        return (
            <TouchableOpacity onPress={onPress} >
                <View style={{
                    flexDirection: 'row', justifyContent: 'space-between', width: Metrics.screenWidth,
                    height: 60, alignItems: 'center', backgroundColor: '#fff', padding: 8, paddingHorizontal: 16
                }}>
                    <TextLabel style={{ fontWeight: 'bold', fontSize: 16 }}>{title}</TextLabel>
                    <Image source={icons.ic_expand_black} />

                </View>
            </TouchableOpacity>
        )
    }
    render() {
        return (
            <Container>
                {this._renderBtn('Bank Account')}
                {this._renderBtn('Debit Card')}
            </Container>
        );
    }
}
const actions = { generalAction, generalSaveAction };
const mapStateToProps = ({ user, networkInfo }) => {
    return { user: user.data, networkInfo };
};

export default connect(
    mapStateToProps,
    actions
)(WithFetching(StripeCardDetails));
