import { StyleSheet } from "react-native";
import Metrics from "../../services/Metrics";
import Colors from "../../services/Colors";
import { Images, icons, UIFont, fontSize, fonts, colors } from "../../assets";

export default StyleSheet.create({
    container: {
        // width: 350,
        // paddingVertical: 25
        flex:1,
        padding:16
    },
    labelStyle: {
        ...UIFont.font(fonts.semiBold, 16, colors.BlackColor)
    },
    inputWrapper: {
        width: Metrics.screenWidth - Metrics.doubleBaseMargin,
        alignItems: "center",
        backgroundColor: colors.WhiteColor,
        borderRadius: 6,
        shadowColor: colors.BlackColor,
        shadowOpacity: 0.4,
        shadowRadius: 2,
        shadowOffset: {
            height: 2,
            width: 2
        },
        paddingVertical: 10,
        marginBottom: 20
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start"
    },
    emailAddressTextField: {
        width: "95%",
        flexDirection: "row",
        alignItems: "center",
        borderColor: "#dddddd",
        borderBottomWidth: 1
    },
    txtInputStyle: {
        minHeight: 50,
        fontSize: 20,
        color: "#000",
        borderRadius: 10,
        paddingLeft: 15,
        paddingBottom: 5,
        marginBottom: 10,
        paddingRight: 15,
        marginHorizontal: 10,
        alignSelf: "stretch",
        flex: 1,
        borderColor: "#dddddd",
        borderBottomWidth: 1
    },
    datePickerInput: {
        width: "90%",
        borderColor: "#dddddd",
        borderBottomWidth: 1,
        marginHorizontal: 20
    },
    dateInput: {
        borderWidth: 0,
        justifyContent: "flex-start",
        alignItems: "flex-start",
        paddingTop: 6,
        marginHorizontal: 10
    },
    categoryStyle: {
        width: "90%",
        flexDirection: "row",
        height: 60,
        alignItems: "center"
    },
    seperatorStyle: {
        backgroundColor: "#dddddd",
        width: "90%",
        alignSelf: "center",
        marginBottom: 10
    },
    actionSheetView: {
        justifyContent: "space-between",
        paddingBottom: Metrics.baseMargin
    },
    zeroIndexCategoryStyle: {
        ...UIFont.font(fonts.reqular, 15, Colors.textfieldBorder),
        marginLeft: "2%",
        paddingHorizontal: 10,
        marginHorizontal: 20,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    textCategoryStyle: {
        ...UIFont.font(fonts.reqular, 15, "#040404"),
        marginLeft: "2%",
        paddingHorizontal: 10,
        marginHorizontal: 20,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    imageIcon: {
        marginTop: Metrics.baseMargin,
        marginRight: Metrics.baseMargin
    }
});
