import React, { Component } from "react";
import { View, StyleSheet, TouchableOpacity } from "react-native";
import { push } from "../../services/NavigationService";
import { colors } from "../../assets";
import { Icon } from "react-native-elements";


const Supporticon = ({
    style,
    clickBtn,
  }) => {
    return (
        <TouchableOpacity 
        activeOpacity={0.7}
        onPress={clickBtn}
        style={[styles.touchableopacitystyle, style]}>
        <Icon
            style={styles.iconstyle}
            reverse
            name="headset"
            type='fontawesome'
            color='rgb(8, 84, 140)'
        />

    </TouchableOpacity>

);
};

const styles = StyleSheet.create({
    touchableopacitystyle: {
        position: 'absolute',
        width: 50,
        height: 50,
        alignItems: 'center',
        justifyContent: 'center',
        right: 30,
        bottom: 30
    },
    iconstyle:{
        resizeMode: 'contain',
        width: 50,
        height: 50,
    },
  
});

export default Supporticon;

