import React, { Component } from "react";
import PropTypes from "prop-types";
import {
    Text,
    Image,
    TouchableOpacity,
    StyleSheet,
    View,
    ScrollView,
    SafeAreaView
} from "react-native";
import { icons, colors } from "../../assets";
import { pop } from "../../services/NavigationService";
import { generalAction, generalSaveAction } from "../../actions/GeneralActions";
import { connect } from "react-redux";
import { API_GET_TERMS_CONDITIONS } from "../../services/WebService";
import { TERMS_CONDITIONS } from "../../actions/ActionTypes";
import HTML from "react-native-render-html";

class TermsNCondtions extends Component {
    static navigationOptions = ({ navigation }) => {
        return {
            headerStyle: styles.header,
            headerTitleStyle: styles.headerTitle,
            headerLeft: (
                <TouchableOpacity onPress={() => pop()}>
                    <Image
                        style={{ margin: 10 }}
                        resizeMode="contain"
                        source={icons.ic_arrow_backward_black}
                    />
                </TouchableOpacity>
            ),
            headerRight: (
                <View
                    style={{
                        backgroundColor: colors.HeaderColor,
                        width: "10%"
                    }}
                />
            )
        };
    };

    state = {
        agreement: "Loading..."
    };

    componentDidMount() {
        this.props.generalAction(
            API_GET_TERMS_CONDITIONS,
            {},
            TERMS_CONDITIONS.SUCCESS,
            TERMS_CONDITIONS.FAILURE,
            data => this.setState({ agreement: data.content }),
            () => {},
            true
        );
    }

    render() {
        const { agreement } = this.state;
        return (
            <ScrollView
                style={{
                    flex: 1,
                    paddingHorizontal: 10
                }}
            >
                <HTML html={agreement} />
            </ScrollView>
        );
    }
}

const actions = { generalAction };
const mapStateToProps = ({ termsNConditions }) => ({});

export default connect(mapStateToProps, actions)(TermsNCondtions);

const styles = StyleSheet.create({
    headerTitle: {
        color: colors.BlackColor,
        alignSelf: "center",
        textAlign: "center",
        justifyContent: "center",
        flex: 1,
        fontWeight: "bold",
        textAlignVertical: "center"
    },
    header: {
        borderBottomWidth: 0,
        backgroundColor: colors.cardColor,
        shadowColor: "transparent",
        elevation: 0,
        shadowRadius: 0,
        shadowOffset: {
            height: 0
        }
    }
});
