import _ from "lodash";
import React from "react";
import PropTypes from "prop-types";
import { Text as TextRN, StyleSheet, Platform } from "react-native";
import Fonts from "../../services/Fonts";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Colors from "../../services/Colors";

const Text = (props: Object) => {
    const {
        name,
        email,
        style,
        nameColor,
        emailColor,
        nameSize,
        emailSize,
        nameType,
        emailType,
        textAlign,
        children,
        ...rest
    } = props;
    const textStyle = StyleSheet.flatten([
        {
            textAlign,
            fontFamily: name ? nameType : emailType,
            fontSize: name ? nameSize : emailSize,
            color: name ? nameColor : emailColor,
            backgroundColor: Colors.transparent,
            marginVertical: 4
        },
        style
    ]);

    return (
        <TextRN style={textStyle} {...rest}>
            {children}
        </TextRN>
    );
};

export default Text;
