import { StyleSheet } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";
import Fonts from "../../services/Fonts";
import Colors from "../../services/Colors";

export default StyleSheet.create({
    container: {
        marginBottom: Metrics.baseMargin
    },
    labelStyle: { marginBottom: Metrics.smallMargin },
    textContainer: {
        flexDirection: "row",
        alignItems: "center",
        borderWidth: 1,
        borderColor: Colors.border,
        borderRadius: Metrics.smallMargin
    },
    textInputStyle: {
        ...UIFont.font(fonts.reqular, fontSize.small, "#241332"),
        flex: 1,
        paddingRight: Metrics.baseMargin,
        paddingTop: Metrics.baseMargin,
        letterSpacing: 0
    },
    errorStyle: {
        color: "red",
        fontSize: Fonts.size.xxSmall,
        fontFamily: Fonts.type.regular
    }
});
