import React, { Component } from "react";
import {
    View, Image, ScrollView, Text, TextInput, StyleSheet, TouchableWithoutFeedback,
    TouchableOpacity,
} from "react-native";
import { Container, TextLabel, AppButton, Input, ReusableModal, InfoCard } from "../../components";
import { Images, icons, colors } from "../../assets";
import { compose } from "redux";
import { connect } from "react-redux";
import { generalAction } from "../../actions/GeneralActions";
import { WithFetching } from "../../HOC";
import styles from "./styles";
import { Colors } from "../../services";
import moment from "moment";
import Utils from "../../Utils";
import { Metrics } from "../../theme";
import {
    API_MARK_AS_COMPLETE_CLINICIAN, POST_BREAK_CHECK,
    POST_LATLNG_API, POST_VERIFY_API, BASE_URL
} from "../../services/WebService";
import { DUMP } from "../../actions/ActionTypes";
import { pop } from "../../services/NavigationService";
import DateTimePicker from '@react-native-community/datetimepicker';
import { Overlay } from 'react-native-elements';
import Geolocation from '@react-native-community/geolocation';
import axios from "axios";
import { RadioButton } from 'react-native-paper';
import { API_KEY_GOOGLE } from "../../constants";
import { isEmpty } from "lodash";

let data = {};
let val_loc = '';

class AddContractTiming extends Component {
    constructor(props) {
        data = props.route.params.data;
        val_loc = props.route.params.location;

        const { location_address, category_name, total_hours, shift_start_time, shift_end_time } = data;
        super();
        this.state = {
            totalAmount: 0,
            hours: '',
            current_loc: val_loc,
            show_location: val_loc,
            shift_name: category_name,
            shift_time: shift_start_time + " to " + shift_end_time,
            to_loc: location_address,
            sign_name: '',
            sign_title: '',
            loc_verify_show: data.contract_location_verified,
            location_status: '',
            lunchstarttime: false,
            lunchendtime: false,
            checked_taken: false,
            checked: false,
            Modal: false,
            startTimeErr: "",
            endTimeErr: "",
            radio_value: 'no',
            break_starttime: '',
            break_endtime: '',
            is_break: '',
            breakval_reason: '',
            error_time: false,
            totalhours: total_hours,
            totalAmount_break: this._getRate() * total_hours,
            breakavailable: data.is_break,
            lunch_time_val: '',
            lunch_reason_val: '',
            lunch_available_val: '',
            value_lunchtime: parseFloat(Utils.getLunchValue()),
            location_fetch: ''

        }
    }
    componentDidMount() {

        this.getOneTimeLocation();

    }

    getOneTimeLocation = () => {
        Geolocation.getCurrentPosition(
            (position) => {

                this.setState({ location_fetch: "" })

                const currentLongitude =
                    JSON.stringify(position.coords.longitude);

                const currentLatitude =
                    JSON.stringify(position.coords.latitude);

                this.props.route.params.location == "" ?
                    this.getAddress(currentLatitude, currentLongitude) :
                    this.checkLocation(currentLatitude, currentLongitude);

            },
            (error) => {

                this.setState({ location_fetch: error.message })
            },
            {
                enableHighAccuracy: false,
                timeout: 30000,
                maximumAge: 1000
            },
        );
    };

    checkLocation = (lat, lng) => {

        let self = this;

        const { contract_id, contract_type } = data;

        let params = {
            contract_id: contract_id,
            latitude: lat,
            longitude: lng
        }
        axios.post(BASE_URL + POST_LATLNG_API, params, {
            headers: {
                token: "api.Pd*!(5675",
                api_version: '1.0',
                api_client: 'android'
            }
        })
            .then(function (response) {

                const checkval = response.data.message;

                if (checkval != 'failure') {

                    self.setState({ location_status: true })

                    self.setState({ show_location: self.state.to_loc })


                } else {

                    self.setState({ location_status: false })

                }


            })
            .catch(function (error) {
                console.log(error);
            })
    }


    showModal = () => {

        const { hours, loc_verify_show, breakavailable,
            radio_value, break_starttime, break_endtime, breakval_reason } = this.state;


        if (breakavailable == "yes") {


            if (radio_value == "yes") {

                // if (break_starttime > break_endtime) {

                //     Utils.showError("Enter valid Lunch break Time");

                // }
                if (break_starttime && break_endtime) {

                    this.Modal.setModalVisible(true);

                }
                else {

                    this.setState({ isError: true });

                }

            }
            else if (radio_value == "no") {

                if (breakval_reason) {

                    this.gettotalvalue("", "");
                    this.Modal.setModalVisible(true);

                }
                else {

                    this.setState({ isError: true });

                }

            }
        }
        else {

            this.Modal.setModalVisible(true);
        }

    };

    hideModal = () => {
        this.Modal.setModalVisible(false);
    };
    renderModal = () => {
        const { project_validity, shift_start_time, shift_start_date, shift_end_time, shift_end_date,
        } = data;

        const { hours, totalAmount_break, totalhours } = this.state;
        let totalHours = Utils.isEmpty(hours) ? totalhours : parseInt(hours);

        return (
            <ReusableModal ref={ref => (this.Modal = ref)}>
                <TouchableWithoutFeedback onPress={this.hideModal}>
                    <View blurRadius={1} style={{ flex: 1, backgroundColor: "rgba(0,0,0,0.5)", alignItems: 'center', justifyContent: 'center' }}>
                        <TouchableOpacity onPress={() => this.hideModal()} style={{ width: 50, height: 50, margin: 16, position: 'absolute', top: 0, left: 0 }}>
                            <Image source={icons.ic_cross} style={{ tintColor: '#fff' }} />
                        </TouchableOpacity>
                        <View style={{
                            padding: 8,
                            width: Metrics.screenWidth - 40,
                            backgroundColor: "#fff", alignItems: 'center'
                        }}>
                            <TextLabel
                                style={Styles.sub_heading}>
                                {'Review your payment Breakdown'}
                            </TextLabel>
                            <View style={[Styles.item, { marginLeft: 24 }]}>
                                {this._renderItem('Contract Duration', project_validity)}
                                {this._renderItem('Working Days', this._getWorkingDays())}
                            </View>
                            <View style={[Styles.item, { marginLeft: 24 }]}>
                                {this._renderItem('Start Date', shift_start_date)}
                                {this._renderItem('Hourly Rate', `$${this._getRate()}`)}
                            </View>
                            <View style={[Styles.item, { marginLeft: 24 }]}>
                                {this._renderItem('End Date', shift_end_date)}
                                {this._renderItem('Shift Hours',
                                    Utils.calculateDiffTime(shift_end_time, shift_start_time).toFixed(2))}
                            </View>
                            <View style={[Styles.item, { marginLeft: 24 }]}>
                                {this._renderItem('Total Shift Hours', parseFloat(totalhours).toFixed(2))}

                                {this.state.radio_value == "no" ?

                                    this._renderItem('Total Fees', (this._getRate() * totalhours).toFixed(2))

                                    : this._renderItem('Total Fees', totalAmount_break.toFixed(2))}

                                {/* {this._renderItem('Total Fees', (this._getRate() * totalHours).toFixed(2))} */}
                            </View>
                        </View>
                        <AppButton
                            buttonTitle="SUBMIT"
                            style={{ backgroundColor: colors.ActiveTabTitle, width: Metrics.screenWidth, position: "absolute", bottom: 0 }}
                            btnColor={'#fff'}
                            onPress={() => this.onSubmit()}
                        />

                    </View>
                </TouchableWithoutFeedback>
            </ReusableModal>
        );
    };
    onSubmit = () => {
        const { id } = this.props.user;
        const { total_hours, contract_id, contract_type } = data;
        const { hours, lunch_available_val, lunch_reason_val, lunch_time_val,
            totalAmount_break } = this.state;

        let totalHours = Utils.isEmpty(hours) ? total_hours : parseInt(hours);

        let totalAmount = this._getRate() * totalHours;

        this.props.cbShowLoader(true);
        let payload = new FormData();
        payload.append('contract_id', contract_id)
        payload.append('shift_start_time', '')
        payload.append('shift_end_time', '')
        payload.append('total_hours', totalHours)
        payload.append('total_amount', this.state.radio_value == "yes" ? totalAmount_break : totalAmount)
        payload.append('contractor_id', id)
        payload.append('contract_type', contract_type);
        payload.append('lunch_break', lunch_available_val);
        payload.append('lunch_break_reason', lunch_reason_val);
        payload.append('lunch_break_time', lunch_time_val);

        this.props.generalAction(
            API_MARK_AS_COMPLETE_CLINICIAN,
            payload,
            DUMP.SUCCESS,
            DUMP.FAILURE,
            this.cbSuccess,
            this.cbFailure
        );
    };


    cbSuccess = (response, message) => {
        this.hideModal();

        Utils.showMessage("Success", message, "success");

        if (this.state.loc_verify_show == null) {

            this.setState({ Modal: true })

        }
        else {

            setTimeout(() => {
                pop(2)
            }, 300);

        }


        this.props.cbShowLoader(false);

    }

    radio_fun = value => {

        const { hours } = this.state;

        if (value == 'yes') {

            this.setState({ radio_value: value });
            // this.setState({ totalAmount_break: this._getRate() * total_hours });

        }
        else {

            this.setState({ break_starttime: "" });
            this.setState({ break_endtime: "" });
            this.setState({ totalAmount_break: this._getRate() * hours });
            this.setState({ radio_value: value });

        }

    }

    cbFailure = (error) => {
        this.props.cbShowLoader(false);
        Utils.showError(error);
    }

    _renderItem = (key, value) => {
        return (
            <View style={{ flex: 1 }}>
                <TextLabel style={Styles.heading}>{key}</TextLabel>
                <TextLabel style={Styles.sub_heading}>{value}</TextLabel>
            </View>
        );
    }

    hourlyCard() {
        return (
            <View style={[{ padding: 16, backgroundColor: '#fff' }]}>
                <TextLabel
                    style={Styles.heading}>
                    {'Enter Total Shift Hours'}
                </TextLabel>
                <Input
                    blurOnSubmit={true}
                    placeholder={"8"}
                    returnKeyType="done"
                    keyboardType="numeric"
                    textFieldStyle={[
                        styles.emailAddressTextField,
                        { width: Metrics.screenWidth - 16, paddingTop: 0 }
                    ]}
                    cbOnChangeText={(txt) =>
                        this.checkLunch_text(txt)
                    }
                />
                {/* {!this.state.error_time &&
                    this.renderError("Hourly Rate is required", {
                    })}  */}
                {/* this.setState({ hours: txt }) */}

            </View>
        );
    }

    checkLunch_text = txt => {

        if (isNaN(txt)) {

            Utils.showError("Enter Valid number");

        }
        else {

            if (isEmpty(txt)) {

                const { total_hours, is_break } = data;

                this.setState({ hours: total_hours })

                this.setState({ totalhours: total_hours })
                this.setState({ breakavailable: "" })
                this.setState({
                    lunch_available_val: "",
                    lunch_reason_val: "",
                    lunch_time_val: ""
                });

                this.setState({ totalAmount_break: this._getRate() * total_hours })

                this.setState({ break_starttime: "" });
                this.setState({ break_endtime: "" });

            }
            else {



                this.setState({ hours: txt })
                this.setState({ totalhours: txt })


                this.setState({ break_starttime: "" });
                this.setState({ break_endtime: "" });
                // this.state.radio_value == "yes" ?
                //     this.gettotalvalue(this.state.break_endtime, txt)
                //      :
                //     this.setState({ totalAmount_break: this._getRate() * txt });

                this.setState({ totalAmount_break: this._getRate() * txt })

                var show_lunch = txt / this._getWorkingDays().toFixed();

                // this.state.breakavailable == "yes" ? null :
                show_lunch.toFixed(2) >= this.state.value_lunchtime ? this.setState({ breakavailable: "yes" }) :
                    this.setState({ breakavailable: "no" })

            }

        }
    }

    labelText = (label, topMargin = {}) => {
        return (
            <TextLabel
                color={colors.ActiveTabTitle}
                style={[styles.textLabel, topMargin]}
            >
                {label}
            </TextLabel>
        );
    };
    renderError(err, obj = { marginTop: 4 }) {
        if (this.state.isError) {
            return <Text style={[styles.error, obj]}>{err}</Text>;
        }
    }
    _getRate = () => {
        const { contract_rate, contract_invitations, total_hours } = data;

        const { bid_amount } = contract_invitations;
        let rate = !Utils.isNull(bid_amount) && bid_amount !== '0.00' ? parseFloat(bid_amount) : parseFloat(contract_rate);
        return rate;
    }
    _getWorkingDays = () => {
        const { shift_start_date, shift_end_date, } = data;

        let diffDays = moment(shift_start_date, "MM-DD-YYYY").diff(
            moment(shift_end_date, "MM-DD-YYYY"), "days");
        let days = Math.abs(diffDays)
        return ++days;
    }

    lunchColumn() {
        const {
            break_starttime, break_endtime,
            radio_value, breakval_reason } = this.state;

        return (

            <View style={{ marginTop: 10, marginBottom: 10 }}>
                <View style={{ paddingLeft: 10, flexDirection: 'row' }}>

                    <RadioButton.Group onValueChange={(value) => this.radio_fun(value)}
                        value={radio_value}>
                        <View style={{ flexDirection: 'row' }}>

                            <RadioButton value="yes" />
                            {this.labelText("Taken")}

                            <RadioButton value="no" />

                            {this.labelText("Not Taken")}
                        </View>
                    </RadioButton.Group>
                </View>

                {radio_value == 'yes' ?
                    <View style={{ paddingLeft: 16, flexDirection: 'row' }}>

                        <View style={{
                            flex: 1, flexDirection: 'column',
                            marginRight: 10,
                        }}>
                            {this.labelText("Start Lunch Time")}

                            {Utils.isPlatformAndroid ?
                                <TouchableOpacity style={styles.viewrowstyle}
                                    onPress={showstartdate => {
                                        this.setState({ lunchstarttime: true });
                                    }}>

                                    <View style={styles.passwordContainer}>

                                        <TextInput
                                            style={styles.inputStyletime}
                                            editable={false}
                                            selectTextOnFocus={false}
                                            placeholder="Start Time"
                                            value={this.state.break_starttime}
                                        />
                                        <Image style={styles.ImageStyle}
                                            source={icons.ic_time}
                                        />

                                    </View>
                                </TouchableOpacity> :
                                this.datePicker(
                                    "Start Time",
                                    icons.ic_time,
                                    "time",
                                    this.setLunchStartTime,
                                    break_starttime,
                                    "HH:mm:A"
                                )}

                            {this.state.lunchstarttime == true ?
                                this.datePickerandorid("time", this.setLunchandroidStartTime,
                                    this.state.break_starttime, "HH:mm:A") : null}

                            {!break_starttime &&
                                this.renderError("Start Time is required", {
                                    paddingHorizontal: 5
                                })}
                            {this.state.startTimeErr.length > 0 &&
                                this.renderError(this.state.startTimeErr, {
                                    paddingHorizontal: 5
                                })}

                        </View>

                        <View style={{ flex: 1, flexDirection: 'column', marginRight: 10, }}>

                            {this.labelText("End Lunch Time",)}

                            {Utils.isPlatformAndroid ?
                                <TouchableOpacity style={styles.viewrowstyle}
                                    onPress={showstartdate => {
                                        this.setState({ lunchendtime: true });
                                    }}>

                                    <View style={styles.passwordContainer}>
                                        <TextInput
                                            style={styles.inputStyletime}
                                            editable={false}
                                            selectTextOnFocus={false}
                                            placeholder="End Time"
                                            value={this.state.break_endtime}
                                        />
                                        <Image style={styles.ImageStyle}
                                            source={icons.ic_time}
                                        />
                                    </View>
                                </TouchableOpacity> :
                                this.datePicker(
                                    "End Time",
                                    icons.ic_time,
                                    "time",
                                    this.setLunchEndTime,
                                    break_endtime,
                                    "HH:mm:A"
                                )}

                            {this.state.lunchendtime == true ?
                                this.datePickerandorid("time", this.setLunchandroidEndTime,
                                    this.state.break_endtime, "HH:mm:A") : null}

                            {!break_endtime && this.renderError("End Time is required")}
                            {this.state.endTimeErr.length > 0 && this.renderError(this.state.endTimeErr)}

                            {break_endtime < break_endtime && this.renderError("select valid start and end time")}

                        </View>
                    </View>

                    : <View
                        style={[
                            styles.modalFirstColumn,
                            { paddingLeft: 16, marginVertical: 10 }]} >
                        {this.labelText("Lunch Break Reason :")}
                        <TextInput
                            numberOfLines={5}
                            multiline={true}
                            onChangeText={(value) => this.setState({ breakval_reason: value })}
                            style={styles.inputMessageStyle}
                        />

                        {!breakval_reason && this.renderError("Enter the Reason")}

                    </View>}

            </View>
        );
    }

    render() {
        const { project_validity, shift_start_time, shift_start_date, shift_end_time, shift_end_date,
        } = data;
        const { totalAmount_break, totalhours } = this.state;

        return (
            <Container>
                <ScrollView>
                    <View style={Styles.container}>
                        <View style={Styles.item}>
                            {this._renderItem('Contract Duration', project_validity)}
                            {this._renderItem('Working Days', this._getWorkingDays())}
                        </View>
                        <View style={Styles.item}>
                            {this._renderItem('Start Date', shift_start_date)}
                            {this._renderItem('Hourly Rate', `$${this._getRate()}`)}
                        </View>
                        {/* big amount */}
                        <View style={Styles.item}>
                            {this._renderItem('End Date', shift_end_date)}
                            {this._renderItem('Shift Hours',
                                Utils.calculateDiffTime(shift_end_time, shift_start_time).toFixed(2))}
                        </View>
                        <View style={Styles.item}>
                            {this._renderItem('Total Shift Hours', parseFloat(totalhours).toFixed(2))}

                            {this.state.breakavailable == "no" ?
                                this._renderItem('Total Fees', (this._getRate() * totalhours).toFixed(2)) :

                                this.state.radio_value == "no" ?

                                    this._renderItem('Total Fees', (this._getRate() * totalhours).toFixed(2))

                                    : this._renderItem('Total Fees', totalAmount_break.toFixed(2))}


                            {/* {this._renderItem('Total Fees', (this._getRate() * total_hours).toFixed(2))} */}
                        </View>
                    </View>

                    {this.state.breakavailable == "yes" ?
                        this.lunchColumn() : null}
                    <InfoCard
                        item={data}
                        style={{ marginTop: 40 }}
                    />
                    {
                        this.hourlyCard()
                    }




                </ScrollView>
                <AppButton
                    buttonTitle="SUBMIT"
                    style={{ backgroundColor: colors.ActiveTabTitle, fontWeight: 'bold' }}
                    btnColor={'#fff'}
                    onPress={() => { this.showModal() }}
                />

                <View style={styles.centeredView}>
                    <Overlay
                        animationType="slide"
                        transparent={true}
                        visible={this.state.Modal}
                        onRequestClose={() => {

                            this.setState({ Modal: false })
                            pop(2);
                        }}>
                        <ScrollView
                            showsHorizontalScrollIndicator={false}
                            keyboardShouldPersistTaps="always"
                            style={{

                                // flexDirection: 'row',
                                flexGrow: 0,
                                //width: '100%',
                            }}>
                            <View >

                                <TouchableOpacity
                                    activeOpacity={1}
                                //  onPressOut={() => this.hidemodebox()}
                                >

                                    <View style={styles.modalView}>

                                        {this.labelText("Title/certification")}
                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.shift_name}
                                            editable={false}
                                            selectTextOnFocus={false}

                                            style={styles.inputhiddenStyle} />

                                        {this.labelText("Timing")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.shift_time}
                                            editable={false}
                                            selectTextOnFocus={false}
                                            style={styles.inputhiddenStyle}
                                        />

                                        {this.labelText("Current Location")}


                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.show_location}
                                            editable={false}
                                            autoFocus={true}
                                            selection={{ start: 0, end: 0 }}
                                            style={styles.inputhiddenStyle} />

                                        {this.state.location_fetch == "" ? null
                                            : this.labelLocationerror(this.state.location_fetch)}

                                        {this.labelText("To Location")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            value={this.state.to_loc}
                                            editable={false}
                                            autoFocus={true}
                                            selection={{ start: 0, end: 0 }}
                                            style={styles.inputhiddenStyle} />

                                        {this.state.location_status ? this.labelLocationText("Location is  Matched")
                                            : this.labelLocationerror("Location is not Matched")}


                                        {this.labelText("Signature")}

                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            placeholder="Enter name"
                                            onChangeText={(entry) => {
                                                this.setState({
                                                    sign_name: entry
                                                })
                                            }}
                                            style={styles.inputStyle} />

                                        {!this.state.sign_name &&
                                            this.renderError(`Name is required`)}
                                        <TextInput
                                            mode='outlined'
                                            textAlignVertical="top"
                                            placeholder="Enter Title"
                                            onChangeText={(entry) => {
                                                this.setState({
                                                    sign_title: entry
                                                })
                                            }}
                                            style={styles.inputStylelast} />

                                        {!this.state.sign_title &&
                                            this.renderError(`Title is required`)}

                                        <View style={{
                                            flexDirection: "row", alignItems: 'center', alignSelf: 'center',
                                            alignContent: 'center'
                                        }}>
                                            <View style={styles.buttonStyleback}>
                                                <AppButton
                                                    buttonTitle="CANCEL"
                                                    style={{
                                                        backgroundColor: "#d45404", height: 50,
                                                        height: 50,
                                                        width: "100%", alignItems: 'center'
                                                    }}
                                                    btnColor="#d45404"
                                                    onPress={() => {
                                                        this.setState({ Modal: false })
                                                    }}
                                                />
                                            </View>
                                            <View style={styles.buttonStyle}>
                                                <AppButton
                                                    buttonTitle="VERIFY"
                                                    style={{
                                                        backgroundColor: colors.ActiveTabTitle,
                                                        height: 50,
                                                        width: "100%", alignItems: 'center'
                                                    }}
                                                    btnColor={colors.cardColor}
                                                    onPress={() => {
                                                        this.verifyShiftClose();
                                                    }}

                                                />

                                            </View>
                                        </View>
                                        {/* <Button
                                        title="Verify"
                                        color={"#bb050c"}
                                        style={styles.modalFooter}
                                        onPress={() =>
                                            this.verifyShiftClose()
                                        }>
                                    </Button> */}
                                    </View>
                                </TouchableOpacity>
                            </View>

                        </ScrollView>
                    </Overlay>


                </View>
                {this.renderModal()}
            </Container >
        );
    }

    datePickerandorid(modeval, setDate, datavalue, formatval) {
        const { shift_start_date } = this.state;
        return (

            <View>

                <DateTimePicker
                    style={{
                        borderBottomWidth: 1,
                        borderColor: Colors.textfieldBorder,
                        width: Platform.OS ? 345 : 350,
                        height: 50
                    }}
                    date={datavalue}
                    mode={modeval}
                    dateFormat={formatval}
                    minimumDate={new Date()}
                    value={new Date()}
                    confirmBtnText="Confirm"
                    cancelBtnText="Cancel"
                    is24Hour={true}
                    customStyles={{
                        dateInput: {
                            borderWidth: 0,
                            justifyContent: "flex-start",
                            alignItems: "flex-start",
                            //                            paddingTop: 6,
                            //   paddingLeft: 10
                        },
                        dateText: {
                            color: "#241332"
                        }
                    }}
                    onChange={setDate}

                />

            </View>
        );
    }
    setLunchStartTime = time => {
        this.setState(
            {
                break_starttime: time,
                startTimeErr: "",
                endTimeErr: ""
            }
        );

        // if (this.state.shift_start_time > starttime) {

        //     Utils.showError("Enter valid Lunch break Time");

        //     this.setState({ break_starttime: '' })

        // }
    };

    setLunchEndTime = time => {
        this.setState(
            {
                break_endtime: time,
                startTimeErr: "",
                endTimeErr: ""
            }
        );

        if (this.state.break_starttime > time) {

            Utils.showError("Enter valid Lunch break Time");
            this.setState({ break_endtime: '' })

        } else {

            this.gettotalvalue(time, "");

        }
    };

    setLunchandroidStartTime = (event, time) => {

        const starttime = moment(time).format("HH:mm:A");

        this.setState(
            {
                break_starttime: starttime,
                startTimeErr: "",
                endTimeErr: "",
                lunchstarttime: false
            }
        );

        // if (this.state.shift_start_time > starttime) {

        //     Utils.showError("Enter valid Lunch break Time");

        //     this.setState({ break_starttime: '' })

        // }
    };

    setLunchandroidEndTime = (event, time) => {

        const endtime = moment(time).format("HH:mm:A");
        this.setState(
            {
                break_endtime: endtime,
                startTimeErr: "",
                endTimeErr: "",
                lunchendtime: false

            }
        );

        if (this.state.break_starttime > endtime) {

            Utils.showError("Enter valid Lunch break Time");

            this.setState({ break_endtime: '' })


        } else {

            this.gettotalvalue(endtime, "");

        }
    };

    gettotalvalue = (endtime, total_hours) => {

        let self = this;

        var Working_days = this._getWorkingDays();

        const c_id = this.props.route.params.data.contract_id;
        let params = {
            contract_id: c_id,
            break_start_time: self.state.break_starttime,
            break_end_time: endtime,
            is_break_available: self.state.radio_value,
            break_reason: self.state.breakval_reason,
            contract_days: Working_days,
            total_hours: total_hours == "" ? self.state.totalhours : total_hours,
        }

        axios.post(BASE_URL + POST_BREAK_CHECK, params, {
            headers: {
                token: "api.Pd*!(5675",
                api_version: '1.0',
                api_client: 'android'
            }
        })
            .then(function (response) {

                if (response.data.code == 200) {

                    self.setState({
                        totalAmount_break: response.data.data[0].total_amount
                    });

                    var timeval = response.data.data[0].break_details.lunch_break_time;
                    var reasonval = response.data.data[0].break_details.lunch_break_reason;
                    var availableval = response.data.data[0].break_details.lunch_break;

                    self.setState({
                        lunch_available_val: availableval,
                        lunch_reason_val: reasonval,
                        lunch_time_val: timeval
                    });

                }

                else if (response.data.code == 400) {

                    self.setState(
                        {
                            break_endtime: ""
                        })
                    Utils.showError(response.data.message);


                }
            })
            .catch(function (error) {
                console.log(error);
            })
    }

    verifyShiftClose = () => {

        let self = this;

        const c_id = this.props.route.params.data.contract_id;

        const {
            sign_name,
            sign_title } = this.state;

        if (sign_name && sign_title) {

            let params = {
                contract_id: c_id,
                name: this.state.sign_name,
                title: this.state.sign_title
            }
            this.props.cbShowLoader(true);

            axios.post(BASE_URL + POST_VERIFY_API, params, {
                headers: {
                    token: "api.Pd*!(5675",
                    api_version: '1.0',
                    api_client: 'android'
                }
            })
                .then(function (response) {

                    const checkval = response.data.message;

                    if (checkval != 'failure') {

                        Utils.showMessage("Success", checkval, "success");
                        self.props.cbShowLoader(false);
                        self.hidemodebox();

                    } else {

                    }
                })
                .catch(function (error) {
                    console.log(error);
                })

        } else {
            this.setState({ isError: true });
        }
    }

    hidemodebox = () => {

        this.setState({ Modal: false });
        setTimeout(() => {
            pop(2)
        }, 300);
    }

    labelLocationText = (label, topMargin = {}) => {
        return (

            <View>
                <TextLabel style={[styles.textLocation, topMargin]}>
                    {label}
                </TextLabel>
            </View>

        );
    };

    labelLocationerror = (label, topMargin = {}) => {
        return (

            <View>
                <TextLabel style={[styles.error, topMargin]}>
                    {label}
                </TextLabel>
            </View>

        );
    };

    getAddress(latitude, longitude) {

        fetch(
            `https://maps.googleapis.com/maps/api/geocode/json?address=${latitude},${longitude}&key=${API_KEY_GOOGLE}`).
            then((response) => response.json())
            .then((responseJson) => {
                const results = JSON.stringify(responseJson);

                const address_current = responseJson.results[0].formatted_address;

                this.setState({ show_location: address_current })

                this.checkLocation(latitude, longitude);
            }
            );
    }
}
const Styles = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: '#f7f7fa',
        padding: 16
    }, item: {
        marginVertical: 16,
        flexDirection: 'row',
    }, heading: {
        color: colors.ActiveTabTitle,
        fontSize: 16,
        fontWeight: 'bold'
    }, sub_heading: {
        color: colors.BlackColor,
        fontSize: 16,
        fontWeight: 'bold'
    }
});

const actions = { generalAction };

const mapStateToProps = ({ user }) => {
    return {
        user: user.data
    };
};

const ComposeAddShiftTiming = compose(
    connect(mapStateToProps, actions)(WithFetching(AddContractTiming))
);

export default ComposeAddShiftTiming;