import { StyleSheet, Platform } from "react-native";
import { colors, UIFont, fonts, fontSize } from "../../assets";
import Metrics from "../../services/Metrics";

export default StyleSheet.create({

    heading: {
        ...UIFont.font(fonts.regular, fontSize.xLarger, colors.WhiteColor),
        alignSelf: "flex-start",
        marginLeft: 15
    },
    emailAddressTextField: {
        paddingTop: Platform.OS && 20,
        width: "95%",
        flexDirection: "row",
        alignItems: "center",
        borderColor: "#dddddd",
        borderBottomWidth: 1
    },
    textLabel: {
        ...UIFont.font(fonts.semiBold, fontSize.small, colors.ActiveTabTitle),
        alignSelf: "flex-start",
        lineHeight: 21,
        letterSpacing: 0
    },
    error: {
        ...UIFont.font(fonts.reqular, fontSize.small, "red"),
        alignSelf: "flex-start"
    },
    dateInput: {
        borderWidth: 0,
        justifyContent: "flex-start",
        alignItems: "flex-start",
        paddingTop: 6,
        paddingLeft: 10
    },
    inputStyle: {
        ...UIFont.font(fonts.regular, 18, "black")
    },

    inputStyletime: {
        flex: 1,
        height: 40,
        color: colors.BlackColor,
    },
    viewrowstyle: {
        //  width: Metrics.screenWidth - Metrics.ratio(60),
        flexDirection: "row",
        alignItems: "center",
    },
    ImageStyle: {
        margin: 5,
        height: 20,
        width: 20,
        alignSelf: 'center',
        resizeMode: 'stretch',
    },
    passwordContainer: {
        flexDirection: 'row',
        borderBottomWidth: 1,
        borderBottomWidth: 1,
        borderColor: "#241332",
    },
    centeredView: {
        alignSelf: 'center',
        marginTop: 10
    },
    textLocation: {
        ...UIFont.font(fonts.regular, fontSize.small, "green"),
        alignSelf: "flex-start",
        lineHeight: 21,
        marginTop: 10,
        letterSpacing: 0
    },
    error: {
        ...UIFont.font(fonts.regular, fontSize.small, "red"),
        alignSelf: "flex-start",
        lineHeight: 21,
        marginTop: 10,
        letterSpacing: 0
    },
    inputhiddenStyle: {
        fontSize: 16,
        padding: 10,
        marginTop: 5,
        height: 40,
        //  borderTopColor: "rgb(8, 84, 140)",
        borderTopWidth: 2,
        borderLeftWidth: 2,
        borderRightWidth: 2,
        borderBottomWidth: 2,
        borderColor: colors.LightGreyColor,
        color: colors.DarkGreyColor,
        borderRadius: 5,
        marginBottom: 5,
        width: 250,
        alignSelf: "flex-start",
    },
    inputStyle: {
        fontSize: 16,
        padding: 10,
        marginTop: 5,
        height: 40,
        borderTopWidth: 2,
        borderLeftWidth: 2,
        borderRightWidth: 2,
        borderBottomWidth: 2,
        borderColor: "rgb(8, 84, 140)",
        borderRadius: 5,
        marginBottom: 5,
        width: 250,
        alignSelf: "flex-start",
    },
    inputStylelast: {
        fontSize: 16,
        padding: 10,
        marginTop: 5,
        height: 40,
        borderTopWidth: 2,
        borderLeftWidth: 2,
        borderRightWidth: 2,
        borderBottomWidth: 2,
        borderColor: "rgb(8, 84, 140)",
        borderRadius: 5,
        marginBottom: 30,
        width: 250,
        alignSelf: "flex-start",
    },
    modalView: {
        backgroundColor: "white",
        borderRadius: 5,
        padding: 30,
        alignContent: 'center',
        alignSelf: "center",
        alignItems: "center",
        shadowColor: "#000",
        shadowOffset: {
            width: 0,
            height: 2
        },
        shadowOpacity: 0.25,
        shadowRadius: 4,
        //    elevation: 5
    },
    modalFooter: {
        width: "100%",
        borderRadius: 50,

    },

    modalFirstColumn: {
        flex: 2,
        flexDirection: "column",
        justifyContent: "center",
        alignItems: "center"
    },
    inputMessageStyle: {
        marginVertical: 10,
        borderWidth: 1,
        borderColor: colors.DarkGreyColor,
        borderRadius: 3,
        height: Platform.OS && 100,
        textAlignVertical: "top",
        width:
            Metrics.screenWidth -
            Metrics.xDoubleBaseMargin -
            Metrics.xDoubleBaseMargin
    },

    buttonStyle: {
        width: "40%",
        alignItems: 'center',
        marginLeft: 10,
        marginBottom: 30
    },

    buttonStyleback: {
        width: "40%",
        alignItems: 'center',
        marginRight: 10,
        marginBottom: 30
    },
});
